/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.cache.annotation.CacheEvict;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.AppUtil;
import com.artfess.sysConfig.persistence.dao.SysLogsSettingsDao;
import com.artfess.sysConfig.persistence.manager.SysLogsSettingsManager;
import com.artfess.sysConfig.persistence.model.SysLogsSettings;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="sysLogsSettingsManager")
public class SysLogsSettingsManagerImpl
extends BaseManagerImpl<SysLogsSettingsDao, SysLogsSettings>
implements SysLogsSettingsManager {
    public void remove(Serializable id) {
        super.remove(id);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void removeByIds(String ... ids) {
        super.removeByIds(ids);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void create(SysLogsSettings t) {
        super.create((Model)t);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    public void update(SysLogsSettings t) {
        super.update((Model)t);
        SysLogsSettingsManagerImpl bean = (SysLogsSettingsManagerImpl)AppUtil.getBean(this.getClass());
        bean.cleanStatus();
        bean.cleanDays();
    }

    @CacheEvict(value={"bpm:sys:logsSettingStatus"}, key="SYS_LOGS_SETTING_STATUS", pureKey=true)
    protected void cleanStatus() {
    }

    @CacheEvict(value={"bpm:sys:logsSettingDay"}, key="SYS_LOGS_SETTING_SAVE_DAY", pureKey=true)
    protected void cleanDays() {
    }

    @Override
    public Map<String, String> getSysLogsSettingStatusMap() {
        List all = this.list();
        HashMap<String, String> statusMap = new HashMap<String, String>();
        for (SysLogsSettings sysLogsSettings : all) {
            statusMap.put(sysLogsSettings.getModuleType(), sysLogsSettings.getStatus());
        }
        return statusMap;
    }

    @Override
    @Cacheable(value={"bpm:sys:logsSettingDay"}, key="SYS_LOGS_SETTING_SAVE_DAY", pureKey=true)
    public Map<String, Integer> getSysLogsSettingDaysMap() {
        List all = this.list();
        HashMap<String, Integer> saveDayMap = new HashMap<String, Integer>();
        for (SysLogsSettings sysLogsSettings : all) {
            saveDayMap.put(sysLogsSettings.getModuleType(), sysLogsSettings.getSaveDays());
        }
        return saveDayMap;
    }
}

