/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.dao.AppTagsRelationDao;
import com.artfess.sysConfig.persistence.manager.AppTagsRelationManager;
import com.artfess.sysConfig.persistence.model.AppTagsRelation;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppTagsRelationManagerImpl
extends BaseManagerImpl<AppTagsRelationDao, AppTagsRelation>
implements AppTagsRelationManager {
    @Override
    @Transactional
    public void saveAppTags(String appId, String tagIds) {
        String[] ids;
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("APP_ID_", appId);
        ((AppTagsRelationDao)this.baseMapper).deleteByMap(conditionMap);
        for (String tagId : ids = tagIds.split(",")) {
            AppTagsRelation rel = new AppTagsRelation();
            rel.setAppId(appId);
            rel.setTagId(tagId);
            ((AppTagsRelationDao)this.baseMapper).insert((Object)rel);
        }
    }

    @Override
    public List<AppTagsRelation> getByAppId(String appId) {
        HashMap<String, String> condition = new HashMap<String, String>();
        condition.put("APP_ID_", appId);
        return ((AppTagsRelationDao)this.baseMapper).selectByMap(condition);
    }

    @Override
    public Set<String> getAppIdsByTagIds(String[] tagIds) {
        return ((AppTagsRelationDao)this.baseMapper).getAppIdsByTagIds(tagIds).stream().collect(Collectors.toSet());
    }
}

