/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.service.ws.cxf.parse.impl;

import com.artfess.base.util.BeanUtils;
import com.artfess.service.exception.WSDLParseException;
import com.artfess.service.ws.cxf.parse.CxfParseService;
import com.artfess.service.ws.model.SoapBindingInfo;
import com.artfess.service.ws.model.SoapBindingOperationInfo;
import com.artfess.service.ws.model.SoapParamInfo;
import com.artfess.service.ws.model.SoapService;
import com.artfess.service.ws.model.SoapServiceInfo;
import com.artfess.service.ws.security.AuthInfoContext;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.springframework.stereotype.Service;

@Service
public class CxfParseServiceImpl
implements CxfParseService {
    private static final Log logger = LogFactory.getLog(CxfParseServiceImpl.class);
    private String[] javaDataType = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.Byte", "java.lang.Double", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Number", "java.util.Date", "java.math.BigInteger", "java.math.BigDecimal", "javax.xml.datatype.XMLGregorianCalendar", "short", "int"};
    private String[] soapVersion = new String[]{"http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/"};

    @Override
    public SoapService parse(Client client) {
        try {
            return this.parseWSDL(client);
        }
        catch (Exception e) {
            throw new WSDLParseException(e.getMessage());
        }
    }

    @Override
    public SoapService parse(File wsdlFile) {
        URL wsdlURL;
        try {
            wsdlURL = wsdlFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new WSDLParseException(e.getMessage());
        }
        Client client = this.createClient(wsdlURL);
        try {
            return this.parseWSDL(client);
        }
        catch (Exception e) {
            throw new WSDLParseException(e.getMessage());
        }
    }

    @Override
    public Client createClient(String wsdlPath) {
        URL wsdlURL;
        logger.debug((Object)("\u5f00\u59cb\u89e3\u6790wsdl:" + wsdlPath));
        try {
            wsdlURL = new URL(wsdlPath);
        }
        catch (MalformedURLException e) {
            throw new WSDLParseException(e.getMessage());
        }
        return this.createClient(wsdlURL);
    }

    @Override
    public Client createClient(File wsdlFile) {
        try {
            return this.createClient(wsdlFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new WSDLParseException(e.getMessage());
        }
    }

    private Client createClient(URL wsdlURL) {
        JaxWsDynamicClientFactory factory = JaxWsDynamicClientFactory.newInstance();
        factory.setJaxbContextProperties(null);
        logger.debug((Object)wsdlURL.toExternalForm());
        Client client = factory.createClient(wsdlURL.toExternalForm());
        if (AuthInfoContext.authed()) {
            AuthorizationPolicy authorization = ((HTTPConduit)client.getConduit()).getAuthorization();
            authorization.setUserName(AuthInfoContext.getProperty("auth_username").toString());
            authorization.setPassword(AuthInfoContext.getProperty("auth_password").toString());
            AuthInfoContext.clear();
        }
        return client;
    }

    @Override
    public SoapService parse(String wsdlPath) {
        try {
            return this.parseWSDL(this.createClient(wsdlPath));
        }
        catch (Exception e) {
            throw new WSDLParseException(e.getMessage());
        }
    }

    private SoapService parseWSDL(Client client) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        org.apache.cxf.service.Service service = client.getEndpoint().getService();
        logger.debug((Object)("\u670d\u52a1\u540d\u79f0\uff1a" + service.getName()));
        SoapService soapService = new SoapService();
        soapService.setName(service.getName().getLocalPart());
        soapService.setNamespace(service.getName().getNamespaceURI());
        this.builderServiceInfo(service, soapService);
        return soapService;
    }

    private void builderServiceInfo(org.apache.cxf.service.Service service, SoapService soapService) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        logger.debug((Object)"\u5f00\u59cb\u6784\u5efa\u670d\u52a1\u4fe1\u606f\u3002");
        List serviceInfos = service.getServiceInfos();
        if (BeanUtils.isEmpty((Object)serviceInfos)) {
            logger.debug((Object)"\u670d\u52a1\u4fe1\u606f\u5185\u5bb9\u4e3a\u7a7a\u3002");
            return;
        }
        for (ServiceInfo serviceInfo : serviceInfos) {
            logger.debug((Object)("\u6b63\u5728\u5904\u7406\u670d\u52a1\u4fe1\u606f\uff1a" + serviceInfo.getName()));
            SoapServiceInfo soapServiceInfo = new SoapServiceInfo();
            soapServiceInfo.setName(serviceInfo.getName().getLocalPart());
            soapServiceInfo.setNamespace(serviceInfo.getName().getNamespaceURI());
            List schemas = serviceInfo.getSchemas();
            if (BeanUtils.isNotEmpty((Object)schemas)) {
                SchemaInfo schemaInfo = (SchemaInfo)schemas.get(0);
                XmlSchemaForm elementFormDefault = schemaInfo.getSchema().getElementFormDefault();
                boolean equals = elementFormDefault.equals((Object)XmlSchemaForm.UNQUALIFIED);
                if (equals) {
                    soapServiceInfo.setElementFormDefault("unqualified");
                } else {
                    soapServiceInfo.setElementFormDefault("qualified");
                }
            }
            this.builderBindingInfo(soapService, serviceInfo, soapServiceInfo);
        }
    }

    private void builderBindingInfo(SoapService soapService, ServiceInfo serviceInfo, SoapServiceInfo soapServiceInfo) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Collection points = serviceInfo.getEndpoints();
        Boolean tag = true;
        if (BeanUtils.isEmpty((Object)points)) {
            logger.debug((Object)"\u670d\u52a1\u7684\u7ed1\u5b9a\u4fe1\u606f\u4e3a\u7a7a\u3002");
            return;
        }
        for (EndpointInfo endpointInfo : points) {
            String address = endpointInfo.getAddress();
            BindingInfo bindingInfo = endpointInfo.getBinding();
            String bingdingId = bindingInfo.getBindingId();
            if (!Arrays.asList(this.soapVersion).contains(bingdingId)) {
                tag = false;
                continue;
            }
            logger.debug((Object)("\u6b63\u5728\u5904\u7406\u670d\u52a1\u7ed1\u5b9a\u4fe1\u606f\uff1a" + bindingInfo.getName()));
            SoapBindingInfo soapBindingInfo = new SoapBindingInfo();
            soapBindingInfo.setName(bindingInfo.getName().getLocalPart());
            soapBindingInfo.setNamespace(bindingInfo.getName().getNamespaceURI());
            soapBindingInfo.setAddress(address);
            this.builderBindingOperationInfo(soapService, bindingInfo, soapBindingInfo);
            soapServiceInfo.putSoapBindingInfo(soapBindingInfo);
        }
        if (tag.booleanValue()) {
            soapService.putSoapServiceInfo(soapServiceInfo);
        }
    }

    private void builderBindingOperationInfo(SoapService soapService, BindingInfo bindingInfo, SoapBindingInfo soapBindingInfo) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Collection bindingOperationInfos = bindingInfo.getOperations();
        if (BeanUtils.isEmpty((Object)bindingOperationInfos)) {
            logger.debug((Object)"\u670d\u52a1\u7684\u7ed1\u5b9a\u7684\u65b9\u6cd5\u4fe1\u606f\u4e3a\u7a7a\u3002");
            return;
        }
        for (BindingOperationInfo bindingOperationInfo : bindingOperationInfos) {
            logger.debug((Object)("\u6b63\u5728\u5904\u7406\u670d\u52a1\u7ed1\u5b9a\u65b9\u6cd5\u4fe1\u606f\uff1a" + bindingOperationInfo.getName()));
            SoapBindingOperationInfo soapBindingOperationInfo = new SoapBindingOperationInfo();
            soapBindingOperationInfo.setName(bindingOperationInfo.getName().getLocalPart());
            soapBindingOperationInfo.setNamespace(bindingOperationInfo.getName().getNamespaceURI());
            this.builderParams(bindingOperationInfo, soapBindingOperationInfo);
            soapBindingInfo.putSoapBindingOperationInfo(soapBindingOperationInfo);
        }
    }

    private void builderParams(BindingOperationInfo bindingOperationInfo, SoapBindingOperationInfo soapBindingOperationInfo) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List outputMessageParts;
        List inputMessageParts = bindingOperationInfo.getInput().getMessageParts();
        if (BeanUtils.isNotEmpty((Object)inputMessageParts)) {
            for (MessagePartInfo messagePartInfo : inputMessageParts) {
                logger.debug((Object)("\u6b63\u5728\u5904\u7406\u8f93\u5165\u53c2\u6570:" + messagePartInfo.getName() + ",Index:" + messagePartInfo.getIndex() + ",QName:" + messagePartInfo.getTypeQName()));
                Map<String, Object> structureInfos = this.parseFieldType(messagePartInfo.getTypeClass());
                SoapParamInfo soapParamInfo = new SoapParamInfo();
                soapParamInfo.setName(messagePartInfo.getName().getLocalPart());
                soapParamInfo.setNamespace(messagePartInfo.getName().getNamespaceURI());
                soapParamInfo.setIndex(messagePartInfo.getIndex());
                soapParamInfo.setStructureInfos(structureInfos);
                soapParamInfo.setTypeClass(messagePartInfo.getTypeClass());
                soapBindingOperationInfo.putInputParam(soapParamInfo);
            }
        }
        if (BeanUtils.isNotEmpty((Object)(outputMessageParts = bindingOperationInfo.getOutput().getMessageParts()))) {
            for (MessagePartInfo messagePartInfo : outputMessageParts) {
                logger.debug((Object)("\u6b63\u5728\u5904\u7406\u8f93\u51fa\u53c2\u6570:" + messagePartInfo.getName() + ",Index:" + messagePartInfo.getIndex() + ",QName:" + messagePartInfo.getTypeQName()));
                Map<String, Object> structureInfos = this.parseFieldType(messagePartInfo.getTypeClass());
                SoapParamInfo soapParamInfo = new SoapParamInfo();
                soapParamInfo.setName(messagePartInfo.getName().getLocalPart());
                soapParamInfo.setNamespace(messagePartInfo.getName().getNamespaceURI());
                soapParamInfo.setIndex(messagePartInfo.getIndex());
                soapParamInfo.setStructureInfos(structureInfos);
                soapParamInfo.setTypeClass(messagePartInfo.getTypeClass());
                soapBindingOperationInfo.putOutputParam(soapParamInfo);
            }
        }
    }

    private Map<String, Object> parseFieldType(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        TreeMap<String, Object> beanFields = new TreeMap<String, Object>();
        if (BeanUtils.isEmpty((Object)bean)) {
            return beanFields;
        }
        if (bean instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)bean;
            Type[] actuals = parameterizedType.getActualTypeArguments();
            Type raw = parameterizedType.getRawType();
            HashMap<String, Object> actualsMap = new HashMap<String, Object>();
            for (Type actual : actuals) {
                if (!(actual instanceof Class)) continue;
                Class clazz = (Class)actual;
                String name = clazz.getSimpleName();
                String canonicalName = clazz.getCanonicalName();
                if (Arrays.asList(this.javaDataType).contains(canonicalName)) {
                    actualsMap.put(name, canonicalName);
                    continue;
                }
                actualsMap.put(name, this.parseFieldType(actual));
            }
            beanFields.put("_actual", actualsMap);
            if (raw instanceof Class) {
                beanFields.put("_raw", ((Class)raw).getCanonicalName());
            }
        } else {
            Map paramsStat;
            Field[] fields;
            if (bean instanceof Class) {
                Class cls = (Class)bean;
                if (Arrays.asList(this.javaDataType).contains(cls.getCanonicalName())) {
                    return beanFields;
                }
            }
            if (BeanUtils.isEmpty((Object)(fields = (Field[])(paramsStat = BeanUtilsBean.getInstance().getPropertyUtils().describe(bean)).get("declaredFields")))) {
                return beanFields;
            }
            for (int i = fields.length - 1; i > -1; --i) {
                Field field = fields[i];
                String name = field.getName();
                Class<?> clazz = field.getType();
                Type type = field.getGenericType();
                String canonicalName = clazz.getCanonicalName();
                logger.debug((Object)("\u7c7b\u5c5e\u6027,Name:" + name + ",Type:" + canonicalName + ",GenericType:" + field.getGenericType()));
                if (Arrays.asList(this.javaDataType).contains(canonicalName)) {
                    logger.debug((Object)(canonicalName + "\uff0c\u4e3a\u4e00\u822c\u7c7b\u578b"));
                    beanFields.put(name, canonicalName);
                    continue;
                }
                beanFields.put(name, this.parseFieldType(type));
            }
        }
        return beanFields;
    }
}

