package com.artfess.poi.util;

import com.artfess.poi.Excel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * @Description:
 * @Auther: min.wu
 * @Date: 2023/02/14
 */
@Slf4j
public class CustomHeader {

    /**
     * 合并表头导出方法
     *
     * @param headerNodes
     * @param response
     * @param fileName
     * @param sheetName
     * @throws IOException
     */
    public static void regionExport(List<HeaderNode> headerNodes, HttpServletResponse response, String fileName, String sheetName) throws IOException {
        Excel excel = new Excel();
        excel.sheet().sheetName(sheetName);
        // 产生工作薄对象
        HSSFWorkbook workbook = excel.getWorkBook();
        HSSFSheet sheet = workbook.getSheet(sheetName);

        HSSFCellStyle headStyle = workbook.createCellStyle();
        defaultHeadStyle(headStyle);
        //表头层级
//        int deep = headerNodes.stream().map(HeaderNode::getRow).reduce(Integer::max).orElse(1);
        for (int i = 0; i <= 1; i++) {
            sheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            int row = headerNode.getRow();
            if (row <= 1) {
                int col = headerNode.getColumn();
                excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName()).style(headStyle);
                CellRangeAddress region;
                //是否跨列
                if (headerNode.isOverNode()) {
                    region = new CellRangeAddress(row, 3, col, col);
                } else {
                    region = new CellRangeAddress(row, row, col, (col + headerNode.getOverNodeCount() - 1));
                }
                if (region.getNumberOfCells() > 1) {
                    sheet.addMergedRegionUnsafe(region);
                    //合并后设置下边框
                    RegionUtil.setBorderTop(BorderStyle.THIN, region, sheet);
                    RegionUtil.setBorderLeft(BorderStyle.THIN, region, sheet);
                    RegionUtil.setBorderBottom(BorderStyle.THIN, region, sheet);
                    RegionUtil.setBorderRight(BorderStyle.THIN, region, sheet);
                }
            } else {
                excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName());
            }
        }
    }

    public static void export(List<HeaderNode> headerNodes, HttpServletResponse response, String fileName, String sheetName) throws IOException {
        Excel excel = new Excel();
        excel.sheet().sheetName(sheetName);
        // 产生工作薄对象
        HSSFWorkbook workbook = excel.getWorkBook();
        HSSFSheet sheet = workbook.getSheet(sheetName);

        HSSFCellStyle headStyle = workbook.createCellStyle();
        defaultHeadStyle(headStyle);
        //表头层级
        for (int i = 0; i <= 1; i++) {
            sheet.createRow(i);
        }
        for (HeaderNode headerNode : headerNodes) {
            if(StringUtils.isNotEmpty(headerNode.getHeaderName())) {
                excel.cell(headerNode.getRow(), headerNode.getColumn()).value(headerNode.getHeaderName());
            }
        }
        ExcelUtil.downloadExcel(workbook, fileName, response);
        //本地测试使用
//        FileOutputStream fileOut = null;
//        try {
//            File file = new File("D:/excel/myExcel.xls");
//            fileOut = new FileOutputStream(file);
//            workbook.write(fileOut);
//            System.out.println("----Excle文件已生成------");
//        } catch (Exception e) {
//            e.printStackTrace();
//        } finally {
//            if (fileOut != null) {
//                try {
//                    fileOut.close();
//                } catch (IOException e) {
//                    e.printStackTrace();
//                }
//            }
//        }
    }

    /**
     * 表头样式
     *
     * @param headStyle
     */
    private static void defaultHeadStyle(CellStyle headStyle) {
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);

        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
    }

}
