/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.file.model.FileConfig;
import com.artfess.file.params.FileStorageConfigDTO;
import com.artfess.file.persistence.manager.FileConfigManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/file/fileConfig/v1/"})
@Api(tags={"\u9644\u4ef6\u914d\u7f6e"})
@ApiGroup(group={"group_system"})
public class FileConfigController
extends BaseController<FileConfigManager, FileConfig> {
    @Resource
    private FileConfigManager fileConfigManager;

    @PostMapping(value={"/queryPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<FileConfig> queryPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<FileConfig> queryFilter) {
        return this.fileConfigManager.queryPage(queryFilter);
    }

    @GetMapping(value={"/getOneById"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public FileConfig getOneById(@ApiParam(name="id", value="\u5b9e\u4f53id", required=true) @RequestParam String id) {
        return this.fileConfigManager.getOneById(id);
    }

    @PostMapping(value={"insertFileConfig"})
    @ApiOperation(value="\u65b0\u589e\u9644\u4ef6\u914d\u7f6e", httpMethod="POST", notes="\u65b0\u589e\u9644\u4ef6\u914d\u7f6e")
    public CommonResult<String> insertFileConfig(@ApiParam(name="fileConfig", value="\u9644\u4ef6\u914d\u7f6e\u5bf9\u8c61") @RequestBody FileConfig fileConfig) throws Exception {
        this.fileConfigManager.insertFileConfig(fileConfig);
        return new CommonResult("\u65b0\u589e\u6210\u529f");
    }

    @PostMapping(value={"updateFileConfig"})
    @ApiOperation(value="\u4fee\u6539\u9644\u4ef6\u914d\u7f6e", httpMethod="POST", notes="\u4fee\u6539\u9644\u4ef6\u914d\u7f6e")
    public CommonResult<String> updateFileConfig(@ApiParam(name="fileConfig", value="\u9644\u4ef6\u914d\u7f6e\u5bf9\u8c61") @RequestBody FileConfig fileConfig) throws Exception {
        String id = this.fileConfigManager.updateFileConfig(fileConfig);
        return new CommonResult("\u4fee\u6539\u6210\u529f");
    }

    @DeleteMapping(value={"deleteFileConfig"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u9644\u4ef6\u914d\u7f6e", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u9644\u4ef6\u914d\u7f6e")
    public CommonResult<String> deleteFileConfig(@ApiParam(name="ids", value="\u4e1a\u52a1\u4e3b\u952e\u6570\u7ec4,\u591a\u4e2a\u4e1a\u52a1\u4e3b\u952e\u4e4b\u95f4\u7528\u9017\u53f7\u5206\u9694", required=true) @RequestParam String ids) throws Exception {
        this.fileConfigManager.deleteFileConfig(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"getFileConfigByCode/{code}"})
    @ApiOperation(value="\u901a\u8fc7\u9644\u4ef6\u914d\u7f6e\u7f16\u7801\u67e5\u8be2\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f", httpMethod="GET", notes="\u901a\u8fc7\u9644\u4ef6\u914d\u7f6e\u7f16\u7801\u67e5\u8be2\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f")
    public FileStorageConfigDTO getFileConfigByCode(@ApiParam(name="code", value="\u9644\u4ef6\u914d\u7f6eCODE") @PathVariable String code) throws Exception {
        FileStorageConfigDTO fileConfig = this.fileConfigManager.getFileConfigByCode(code);
        return fileConfig;
    }
}

