/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.runtime.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.workflow.runtime.dao.BpmPrintRecordDao;
import com.artfess.workflow.runtime.manager.BpmPrintRecordManager;
import com.artfess.workflow.runtime.model.BpmPrintRecord;
import com.artfess.workflow.runtime.params.BpmPrintRecordObject;
import java.io.IOException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmPrintRecordManager")
public class BpmPrintRecordManagerImpl
extends BaseManagerImpl<BpmPrintRecordDao, BpmPrintRecord>
implements BpmPrintRecordManager {
    @Override
    public BpmPrintRecord getLastVersion(String procInstId, String nodeId, String templateId) {
        return ((BpmPrintRecordDao)this.baseMapper).getLastVersion(procInstId, nodeId, templateId);
    }

    @Override
    public void cleanLastVersion(String procInstId, String nodeId, String templateId) {
        ((BpmPrintRecordDao)this.baseMapper).cleanLastVersion(procInstId, nodeId, templateId);
    }

    @Override
    @Transactional
    public CommonResult<String> addPrintLog(BpmPrintRecordObject printRecordObject) {
        try {
            BpmPrintRecord newRecord = (BpmPrintRecord)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)printRecordObject), BpmPrintRecord.class));
            newRecord.setId(UniqueIdUtil.getSuid());
            ((BpmPrintRecordDao)this.baseMapper).cleanLastVersion(newRecord.getProcInstId(), newRecord.getNodeId(), newRecord.getTemplateId());
            newRecord.setLastVersion(1);
            super.save((Object)newRecord);
        }
        catch (IOException e) {
            return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(false, "\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u6210\u529f\u3002");
    }
}

