package com.artfess.sysConfig.persistence.manager;



import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.springframework.web.multipart.MultipartFile;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.sysConfig.persistence.model.DataDict;

/**
 * 字典接口管理层
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author maoww
 * @email maoww@jee-soft.cn
 * @date 2018年6月21日
 */
public interface DataDictManager extends  BaseManager<DataDict>{

	/**
	 * 查询所有字典值类型的数据
	 * @return
	 */
	List<DataDict> getAllDataVal() throws Exception;

	/**
	 * 通过数据字典类别查询所有的数据字典项和值
	 * @param typeId
	 */
	List<DataDict> getByTypeId(String typeId);

	/**
	 * 通过数据字典类别查询所有的字典项
	 * @param typeId
	 */
	List<DataDict> getDicByTypeId(String typeId);

	/**
	 * 通过数据字典项ID查询所有的字典项的值
	 * @param dicId 典项ID
	 * @param isDic 是否查询字典项信息
	 */
	List<DataDict> getDicByDicId(String dicId,boolean isDic);

	/**
	 * 通过数据字典项key查询所有的字典的值
	 * @param dicKey
	 */
	List<DataDict> getByDicKey(String dicKey);

	/**
	 * 移动字典
	 * @param ids 字典项ID
	 * @param gId 目的ID
	 * @param type 字典类型（dic：字典项，val:字典值）
	 */
	Boolean moveDic(List<String>ids,String gId,String type);



	/**
	 * 通过 类型和字典key获取字典项
	 * @param type     字典类型(dic:字典项，val:字典值)
	 * @param key 	   字典key
	 * @param dicId     字典项ID
	 * @return
	 */
	DataDict getByKey(String type, String key, String dicId);


	/**
	 * 通过 类型，和字典key 获取字典项
	 * @param typeId 字典类型id
	 * @param key 	   字典key
	 * @return
	 */
	DataDict getByDictKey(String typeId, String key);
	
	/**
	 * 通过父节点获取子节点（包含二级子节点）
	 * @param parentId 父节点
	 * @return
	 */
	List<DataDict> getChildrenByParentId(String parentId);
	
	/**
	 * 通过类型id删除字典
	 * @param id 类型id
	 */
	void delByDictTypeId(String id);
	

	/**
	 * 更新排序  sn
	 * @param dicId 字典id
	 * @param sn	排序
	 */
	void updSn(String dicId, int sn);

	/**
	 * 通过父节点ID获取一级子节点
	 * @param parentId 父节点
	 * @return
	 */
	List<DataDict> getFirstChilsByParentId(String parentId);

	CommonResult<String> removeByTypeIds(String typeIds);
	
	void importData(List<MultipartFile> files, String typeId) throws Exception;

	/**
	 * 导入多维字典项
	 * @return
	 */
	void importDic(MultipartFile file) throws Exception;
}
