package com.artfess.sysConfig.persistence.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @Program: edp
 * @Date: 2021/3/2
 * @Author: ZQF
 * @Description: 系统字典
 */
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "SysDictionary", description = "系统字典")
@TableName("portal_sys_dictionary")
@Data
public class SysDictionary extends BaseModel<SysDictionary> {

    @ApiModelProperty(value = "主键ID")
    @TableId("ID_")
    private String id;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    @ApiModelProperty(value = "公共树节点_ID【外键】")
    @TableField("TREE_ID_")
    private String treeId;

    @ApiModelProperty(value = "编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "名称")
    @TableField(value = "NAME_", condition = SqlCondition.LIKE)
    private String name;

    @ApiModelProperty(value = "类别:(1：系统 2：公司）")
    @TableField("KIND_ID_")
    protected Integer kindId;

    @ApiModelProperty(value = "备注")
    @TableField(value = "MEMO_")
    private String memo;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    protected Integer sn;

    @ApiModelProperty(value = "有效标志（0：无效  1：有效）")
    @TableField("FLAG_")
    protected Integer flag;

    @TableField(exist = false)
    private List<SysDictionaryDetail> details;

}
