/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.consts;

import com.artfess.base.util.AppUtil;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import com.artfess.integrate.util.DingTalkTokenUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class DingTalkConsts {
    private static final String DT_URL = "https://oapi.dingtalk.com";

    public static SysExternalUnite getUnite() {
        SysExternalUniteManager manager = (SysExternalUniteManager)AppUtil.getBean(SysExternalUniteManager.class);
        return manager.getDingtalk();
    }

    public static String getUserUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/user/get?access_token=" + DingTalkTokenUtil.getToken() + "&userid=";
        return url;
    }

    public static String getTokenUrl() {
        return "https://oapi.dingtalk.com/gettoken?appkey=" + DingTalkConsts.getUnite().getAgentKey() + "&appsecret=" + DingTalkConsts.getUnite().getAgentSecret();
    }

    public static String getCreateUserUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/user/create?access_token=" + DingTalkTokenUtil.getToken();
        return url;
    }

    public static String generateMenuUrl(String baseUrl, String corpId) throws UnsupportedEncodingException {
        String redirect_uri = baseUrl + "/home";
        String url = baseUrl + "/dingTalk?corpid=" + corpId + "&redirect_uri=" + URLEncoder.encode(redirect_uri, "UTF-8");
        return url;
    }

    public static String getUserInfo(String code) throws IOException {
        return "https://oapi.dingtalk.com/user/getuserinfo?access_token=" + DingTalkTokenUtil.getToken() + "&code=" + code;
    }

    public static String getMsgSendUrl() {
        return "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    }

    public static String getAuthorize(String paramStr) {
        return DingTalkConsts.getUnite().getBaseUrl() + "/dingTalk?corpid=" + DingTalkConsts.getUnite().getCorpId() + "&params=" + paramStr;
    }

    public static String getDepartmentListUrl() throws IOException {
        String url = "https://oapi.dingtalk.com/department/list";
        return url;
    }

    public static String getUsersByDepartmentId() {
        String url = "https://oapi.dingtalk.com/user/listbypage";
        return url;
    }
}

