package com.artfess.activemq.consumer;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.activemq.model.JmsTableTypeConf;
import com.artfess.activemq.model.JmsTableTypeFiledDetail;
import com.artfess.base.context.BaseContext;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import java.io.Serializable;
import java.util.List;

@Service
@ConditionalOnProperty(value="jms.enable", matchIfMissing = true)
public class JmsSysTypeChangeConsumer {
	private static final Logger logger = LoggerFactory.getLogger(JmsSysTypeChangeConsumer.class);
	@Resource
	CommonManager commonManager;

	@Resource
	BaseContext baseContext;

	@JmsListener(destination = "${jms.topic.name:eipTopic}", containerFactory="jmsListenerContainerTopic")
	public void receiveQueue(Object model) throws JMSException {
		logger.debug("[JMS]: Topic message is :" + model.getClass().getName() + "---" + model);
		handlerSysTypeChange(model);
	}

	private void handlerSysTypeChange(Object source) throws JMSException {
		if (BeanUtils.isEmpty(source) || !(source instanceof ObjectMessage))
			return;

		ObjectMessage message = (ObjectMessage) source;
		Serializable object = message.getObject();
		if (!(object instanceof JmsSysTypeChangeMessage)) {
			return;
		}
		JmsSysTypeChangeMessage type = (JmsSysTypeChangeMessage) object;
		try {
			if (StringUtil.isNotEmpty(type.getTypeGroupKey()) && JmsTableTypeConf.getTypeConf().containsKey(type.getTypeGroupKey().toUpperCase())) {
				List<JmsTableTypeFiledDetail> detailList = JmsTableTypeConf.getTypeConf().get(type.getTypeGroupKey());
				for (JmsTableTypeFiledDetail jmsTableTypeFiledDetail : detailList) {
					chanegType(type,jmsTableTypeFiledDetail);
				}
			}
		} catch (Exception e) {
			logger.error(ExceptionUtil.getExceptionMessage(e));
		}
	}
	
	private void chanegType(JmsSysTypeChangeMessage type ,JmsTableTypeFiledDetail detail){
		StringBuilder sqlSb = new StringBuilder();
		sqlSb.append("UPDATE ").append(detail.getTableName()).append(" set ");
		//如果是删除则将该数据的分类id也置空
		if (2==type.getOpType()) {
			if (StringUtil.isNotEmpty(detail.getTypeIdFiledName())) {
				sqlSb.append(detail.getTypeIdFiledName()).append(" = ''");
			}
			type.setTypeName("");
		}else if (3==type.getOpType()) {
			if (StringUtil.isNotEmpty(detail.getTypeIdFiledName())) {
				sqlSb.append(detail.getTypeIdFiledName()).append(" = '");
				sqlSb.append(type.getTypeId()).append("'");
			}
		}
		//有分类名称字段则更新分类名称
		if (StringUtil.isNotEmpty(detail.getTypeNameFiledName())) {
			if (StringUtil.isNotEmpty(detail.getTypeIdFiledName()) && 1!=type.getOpType()) {
				sqlSb.append(",");
			}
			sqlSb.append(detail.getTypeNameFiledName()).append(" = '").append(type.getTypeName());
		}
		sqlSb.append("' where ");
		//消息的订阅者，与发布者不在同一个线程，无法通过HttpUtil获取到当前租户ID
		if(BeanUtils.isNotEmpty(type.getTenantId())){
			MultiTenantHandler.setThreadLocalIgnore();
			sqlSb.append(detail.getTableName() + ".tenant_id_='" + type.getTenantId()+"' and ");
		}
		if (3==type.getOpType() && StringUtil.isNotEmpty(detail.getPkFiledName())) {
			sqlSb.append(detail.getPkFiledName()).append(" in ('").append(StringUtil.join(type.getEntityIds().split(","), "','")).append("')");
			commonManager.execute(sqlSb.toString());
		}else if (StringUtil.isNotEmpty(detail.getTypeIdFiledName())) {
			sqlSb.append(detail.getTypeIdFiledName()).append("='").append(type.getTypeId()).append("'");
			commonManager.execute(sqlSb.toString());
		}else if (StringUtil.isNotEmpty(detail.getTypeNameFiledName())) {
			sqlSb.append(detail.getTypeNameFiledName()).append("='").append(type.getOldTypeName()).append("'");
			commonManager.execute(sqlSb.toString());
		}
		
	}
}
