/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.AppTagsRelationManager;
import com.artfess.sysConfig.persistence.manager.SysAppManager;
import com.artfess.sysConfig.persistence.model.AppTagsRelation;
import com.artfess.sysConfig.persistence.model.SysApp;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/portal/sysApp/v1"})
@Api(tags={"sysAppController"})
public class SysAppController
extends BaseController<SysAppManager, SysApp> {
    @Resource
    SysAppManager sysAppManager;
    @Resource
    AppTagsRelationManager appTagsRelationManager;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<SysApp> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SysApp> queryFilter) {
        List sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return ((SysAppManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/authList"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528")
    public List<SysApp> authList(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody SysApp sysApp) throws Exception {
        return this.sysAppManager.queryByAuth(sysApp);
    }

    @PostMapping(value={"/queryByFilter"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u67e5\u8be2\u5df2\u6388\u6743\u7684\u5e94\u7528")
    public List<SysApp> queryByFilter(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysApp> queryFilter) throws Exception {
        return this.sysAppManager.queryByFilter(queryFilter);
    }

    @PostMapping(value={"/queryByTagIds/{menuId}"})
    @ApiOperation(value="\u901a\u8fc7\u6807\u7b7eID\u67e5\u8be2\u83b7\u53d6\u5df2\u6388\u6743\u7684\u5e94\u7528", httpMethod="POST", notes="\u901a\u8fc7\u6807\u7b7eID\u67e5\u8be2\u83b7\u53d6\u5df2\u6388\u6743\u5e94\u7528")
    public List<SysApp> queryByTagIds(@ApiParam(name="menuId", value="\u83dc\u5355ID") @PathVariable String menuId, @ApiParam(name="tagMaps", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody List<Map<String, String>> tagMaps) throws Exception {
        return this.sysAppManager.queryByTagIds(menuId, tagMaps);
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0portal_sys_app\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="sysApp", value="\u5e94\u7528\u4fe1\u606f\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysApp sysApp) throws Exception {
        String msg = "\u6dfb\u52a0\u5e94\u7528\u4fe1\u606f\u6210\u529f";
        if (StringUtil.isEmpty((String)sysApp.getId())) {
            this.sysAppManager.create((Model)sysApp);
        } else {
            this.sysAppManager.update((Model)sysApp);
            msg = "\u66f4\u65b0\u5e94\u7528\u4fe1\u606f\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"/remove"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5e94\u7528\u4fe1\u606f\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        this.sysAppManager.removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/publish"})
    @ApiOperation(value="\u53d1\u5e03\u5e94\u7528", httpMethod="POST", notes="\u53d1\u5e03\u5e94\u7528")
    public CommonResult<String> publish(@ApiParam(name="id", value="\u5e94\u7528ID", required=true) @RequestBody SysApp sysApp) throws Exception {
        String message = SysApp.IS_PUBLISH.equals(sysApp.getIsPublish()) ? "\u53d1\u5e03\u6210\u529f" : "\u53d6\u6d88\u53d1\u5e03\u6210\u529f";
        this.sysAppManager.update((Model)sysApp);
        return new CommonResult(true, message);
    }

    @PostMapping(value={"/saveAppTags/{appId}"})
    @ApiOperation(value="\u4fdd\u5b58\u5e94\u7528\u6807\u7b7e", httpMethod="POST", notes="\u4fdd\u5b58\u5e94\u7528\u6807\u7b7e")
    public CommonResult<String> saveAppTags(@ApiParam(name="appId", value="\u5e94\u7528ID", required=true) @PathVariable String appId, @ApiParam(name="tagIds", value="\u6807\u7b7eID\u96c6", required=true) @RequestBody String tagIds) {
        try {
            this.appTagsRelationManager.saveAppTags(appId, tagIds);
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    @GetMapping(value={"/getAppTagsById/{appId}"})
    @ApiOperation(value="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u6807\u7b7e", httpMethod="GET", notes="\u6839\u636e\u5e94\u7528ID\u83b7\u53d6\u5e94\u7528\u6807\u7b7e")
    public CommonResult<List<AppTagsRelation>> getAppTagsById(@ApiParam(name="appId", value="\u5e94\u7528Id", required=true) @PathVariable String appId) throws Exception {
        List byAppId = this.appTagsRelationManager.getByAppId(appId);
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f", (Object)byAppId);
    }

    @GetMapping(value={"/validMenu"})
    @ApiOperation(value="\u83b7\u53d6APP\u9996\u4e2a\u6709\u5185\u5bb9\u7684\u83dc\u5355", httpMethod="GET", notes="\u83b7\u53d6APP\u9996\u4e2a\u6709\u5185\u5bb9\u7684\u83dc\u5355")
    public List<String> validMenu() throws Exception {
        List validMenu = this.sysAppManager.getValidMenu(ContextUtil.getCurrentUserId());
        return validMenu;
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5e94\u7528xml", httpMethod="GET", notes="\u5bfc\u51fa\u5e94\u7528xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u5e94\u7528id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_sysApp_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map strXml = ((SysAppManager)this.baseService).exportData(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (Map)strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e94\u7528\u5bfc\u5165", httpMethod="POST", notes="\u5e94\u7528\u5bfc\u5165")
    public CommonResult<String> importData(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String msg;
            CommonResult message = new CommonResult("\u5bfc\u5165\u6210\u529f");
            ((SysAppManager)this.baseService).importData(request.getFile("file"));
            LinkedHashSet sysAppsSaved = ThreadMsgUtil.getMapMsg2((String)"sysAppsSaved");
            LinkedHashSet sysAppsSkipped = ThreadMsgUtil.getMapMsg2((String)"sysAppsSkipped");
            StringBuilder sb = new StringBuilder();
            if (BeanUtils.isNotEmpty((Object)sysAppsSkipped)) {
                sb.append("<div style='font-weight:bold;'>\u4ee5\u4e0b\u5e94\u7528\u5df2\u5b58\u5728\u6545\u8df3\u8fc7\uff1a</div>");
                msg = String.format("%s", String.join((CharSequence)"", sysAppsSkipped));
                sb.append(msg);
            }
            if (StringUtil.isNotEmpty((String)(msg = sb.toString()))) {
                message.setMessage(msg);
            }
            return message;
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

