/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.portal.params.ActuatorInfo;
import com.artfess.portal.params.TraceInfo;
import com.artfess.portal.persistence.manager.ActuatorSystemService;
import com.artfess.portal.util.HttpUtil;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="actuatorSystemService")
public class ActuatorSystemServiceImpl
implements ActuatorSystemService {
    private static final Logger log = LoggerFactory.getLogger(ActuatorSystemServiceImpl.class);
    String ip;
    @Value(value="${server.port}")
    private String port;

    public ActuatorSystemServiceImpl() {
        try {
            this.ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<TraceInfo> getHttpTrace() throws IOException {
        String httptrace = "http://" + this.ip + ":" + this.port + "/actuator/httptrace";
        ArrayList<TraceInfo> list = new ArrayList<TraceInfo>();
        String entity = HttpUtil.get(httptrace);
        System.out.println(entity);
        JSONArray jsonArray = JSONUtil.parseArray((Object)JSONUtil.parseObj((String)entity).get((Object)"traces"));
        System.out.println(jsonArray);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject((Object)i);
            String timestamp = jsonObject.get((Object)"timestamp").toString().substring(0, jsonObject.get((Object)"timestamp").toString().indexOf("."));
            String timeTaken = jsonObject.get((Object)"timeTaken").toString() + "ms";
            JSONObject request = jsonObject.getJSONObject((Object)"request");
            String method = request.get((Object)"method").toString();
            String uri = request.get((Object)"uri").toString();
            JSONObject headers = request.getJSONObject((Object)"headers");
            String token = null;
            try {
                token = headers.get((Object)"proxy-authorization").toString();
            }
            catch (Exception e) {
                token = null;
            }
            String jsession = null;
            try {
                jsession = headers.get((Object)"cookie").toString();
            }
            catch (Exception e) {
                jsession = null;
            }
            if (StringUtils.isNotBlank((CharSequence)uri)) {
                uri = uri.replace("\"", "").replace("\"", "");
            }
            if (StringUtils.isNotBlank((CharSequence)method)) {
                method = method.replace("\"", "").replace("\"", "");
            }
            if (StringUtils.isNotBlank((CharSequence)jsession)) {
                jsession = jsession.split("; ")[0].replace("[\"", "").replace("\"]", "");
            }
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace("[\"", "").replace("\"]", "");
            }
            TraceInfo trace = new TraceInfo();
            trace.setJSESSIONID(jsession);
            trace.setMethod(method);
            trace.setTimestamp(timestamp);
            trace.setToken(token);
            trace.setUri(uri);
            trace.setTimeTaken(timeTaken);
            list.add(trace);
        }
        return list;
    }

    @Override
    public List<ActuatorInfo> getMetrics(String type) throws IOException {
        String metrics = "http://" + this.ip + ":" + this.port + "/actuator/metrics";
        String entity = HttpUtil.get(metrics);
        JsonNode jsonNode = JsonUtil.toJsonNode((String)entity).get("names");
        ArrayList<ActuatorInfo> infoList = new ArrayList<ActuatorInfo>();
        for (int i = 0; i < jsonNode.size(); ++i) {
            JsonNode node = jsonNode.get(i);
            String jsonObject = node.toString();
            if (jsonObject.indexOf(type) != 1) continue;
            if (StringUtils.isNotBlank((CharSequence)jsonObject)) {
                jsonObject = jsonObject.replace("\"", "").replace("\"", "");
            }
            ActuatorInfo actuatorInfo = new ActuatorInfo();
            String value = HttpUtil.get(metrics + "/" + jsonObject);
            JsonNode measurements = JsonUtil.toJsonNode((String)value).get("measurements");
            Object kv = JsonUtil.toMap((String)measurements.get(0).toString()).get("value");
            actuatorInfo.setKey(jsonObject);
            actuatorInfo.setValue(kv.toString());
            infoList.add(actuatorInfo);
        }
        return infoList;
    }

    @Override
    public Map<String, String> getHealth() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        String health = "http://" + this.ip + ":" + this.port + "/actuator/health";
        String entity = HttpUtil.get(health);
        if (StringUtils.isNotEmpty((CharSequence)entity)) {
            JsonNode jsonNode = JsonUtil.toJsonNode((String)entity);
            String systemStatus = jsonNode.get("status").toString();
            if (StringUtils.isNotBlank((CharSequence)systemStatus)) {
                systemStatus = systemStatus.replace("\"", "").replace("\"", "");
            }
            map.put("systemStatus", systemStatus);
            JsonNode node = jsonNode.get("components");
            Map moduleMap = JsonUtil.toMap((String)node.toString());
            for (String str : moduleMap.keySet()) {
                Map statusMap = (Map)moduleMap.get(str);
                map.put(str, statusMap.get("status").toString());
            }
        }
        return map;
    }

    public static List startPage(List list, Integer pageNum, Integer pageSize) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        Integer count = list.size();
        Integer pageCount = 0;
        pageCount = count % pageSize == 0 ? Integer.valueOf(count / pageSize) : Integer.valueOf(count / pageSize + 1);
        int fromIndex = 0;
        int toIndex = 0;
        if (pageNum != pageCount) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = count;
        }
        List pageList = list.subList(fromIndex, toIndex);
        return pageList;
    }
}

