/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.i18n.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.i18n.persistence.dao.I18nMessageDao;
import com.artfess.i18n.persistence.manager.I18nMessageManager;
import com.artfess.i18n.persistence.manager.I18nMessageTypeManager;
import com.artfess.i18n.persistence.model.I18nMessage;
import com.artfess.i18n.persistence.model.I18nMessageType;
import com.artfess.i18n.support.service.MessageService;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="i18nMessageManager")
public class I18nMessageManagerImpl
extends BaseManagerImpl<I18nMessageDao, I18nMessage>
implements I18nMessageManager {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    I18nMessageDao i18nMessageDao;
    @Resource
    I18nMessageTypeManager i18nMessageTypeManager;
    @Resource
    MessageService messageService;

    @Override
    public PageList<Map<String, String>> getList(QueryFilter filter) {
        QueryField field;
        List typeList = this.i18nMessageTypeManager.list();
        ArrayList<String> types = new ArrayList<String>();
        for (I18nMessageType type : typeList) {
            types.add(type.getType());
        }
        filter.withParam("types", types);
        if (filter.getQuerys().size() > 0 && FieldRelation.AND.equals((Object)(field = (QueryField)filter.getQuerys().get(0)).getRelation())) {
            filter.withParam("relation", (Object)FieldRelation.AND);
        }
        PageBean pageBean = filter.getPageBean();
        Page page = new Page(0L, (long)PageBean.WITHOUT_PAGE.intValue());
        if (BeanUtils.isNotEmpty((Object)pageBean)) {
            page = pageBean == null ? new Page() : new Page((long)pageBean.getPage().intValue(), (long)pageBean.getPageSize().intValue(), pageBean.showTotal());
        }
        this.copyQuerysInParams(filter);
        List<Map<String, String>> map = this.i18nMessageDao.getList((IPage<Map<String, String>>)page, filter.getParams());
        PageList pageList = new PageList(map);
        pageList.setTotal(page.getTotal());
        pageList.setRows(map);
        pageList.setPageSize(page.getSize());
        pageList.setPage(page.getCurrent());
        return pageList;
    }

    @Override
    public Map<String, Object> getByMesKey(String key, String dbType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", key);
        List typeList = this.i18nMessageTypeManager.list();
        ArrayList<String> types = new ArrayList<String>();
        for (I18nMessageType type : typeList) {
            types.add(type.getType());
        }
        params.put("types", types);
        if (dbType.equals("oracle") || dbType.equals("dm")) {
            return this.i18nMessageDao.getByMesKey_oracle(params);
        }
        if (dbType.equals("postgresql")) {
            return this.i18nMessageDao.getByMesKey_pgsql(params);
        }
        if (dbType.equals("h2")) {
            return this.i18nMessageDao.getByMesKey_h2(params);
        }
        return this.i18nMessageDao.getByMesKey_mysql(params);
    }

    @Override
    public void delByKey(String key) {
        this.i18nMessageDao.delByKey(key);
    }

    @Override
    public void delByKeyAndType(String key, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", key);
        params.put("type", type);
        this.i18nMessageDao.delByKeyAndType(params);
    }

    @Override
    public void delByKeys(String ... keys) {
        for (String key : keys) {
            this.delByKey(key);
            this.messageService.delByKey(key);
        }
    }

    @Override
    public Map<String, Object> saveI18nMessage(String key, List<Map<String, String>> mesTypeInfo, String oldKey) {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        for (Map<String, String> m : mesTypeInfo) {
            String type = m.get("type").toString();
            String val = m.get("val");
            I18nMessage i18n = null;
            i18n = key.equals(oldKey) ? this.i18nMessageDao.getByKeyAndType(key, type) : this.i18nMessageDao.getByKeyAndType(oldKey, type);
            if (BeanUtils.isEmpty((Object)((Object)i18n)) && StringUtil.isNotEmpty((String)val)) {
                i18n = new I18nMessage();
                i18n.setId(UniqueIdUtil.getSuid());
                i18n.setType(type);
                i18n.setKey(key);
                i18n.setValue(val);
                this.i18nMessageDao.insert((Object)i18n);
                continue;
            }
            if (BeanUtils.isNotEmpty((Object)((Object)i18n)) && StringUtil.isNotEmpty((String)val)) {
                i18n.setType(type);
                i18n.setKey(key);
                i18n.setValue(val);
                this.i18nMessageDao.updateById((Object)i18n);
                continue;
            }
            if (!BeanUtils.isNotEmpty((Object)((Object)i18n)) || !StringUtil.isEmpty((String)val)) continue;
            this.messageService.hdel(i18n.getKey(), i18n.getType());
            this.i18nMessageDao.deleteById((Serializable)((Object)i18n.getId()));
        }
        rtn.put("result", true);
        rtn.put("msg", "\u56fd\u9645\u5316\u8d44\u6e90\u64cd\u4f5c\u6210\u529f");
        return rtn;
    }

    @Override
    public Map<String, Object> importMessage(MultipartFile file) throws Exception {
        HashMap<String, Object> rtnMap = new HashMap<String, Object>();
        Boolean result = true;
        String console = "";
        if (file == null || file.isEmpty()) {
            result = false;
            console = "\u6587\u4ef6\u4e3a\u7a7a\uff01";
            throw new RuntimeException(console);
        }
        String fileExt = file.getOriginalFilename().substring(file.getOriginalFilename().indexOf("."));
        if (!fileExt.toUpperCase().equals(".XLS") && !fileExt.toUpperCase().equals(".XLSX")) {
            result = false;
            console = "\u4e0a\u4f20\u6587\u4ef6\u4e0d\u662fexcel\u7c7b\u578b\uff01";
            throw new RuntimeException(console);
        }
        Boolean isExcel2003 = true;
        if (fileExt.toUpperCase().equals(".XLSX")) {
            isExcel2003 = false;
        }
        Object wb = null;
        wb = isExcel2003 != false ? new HSSFWorkbook(file.getInputStream()) : new XSSFWorkbook(file.getInputStream());
        ArrayList<I18nMessageType> typeList = new ArrayList<I18nMessageType>();
        ArrayList<I18nMessage> messageAddList = new ArrayList<I18nMessage>();
        ArrayList<I18nMessage> messageUpdateList = new ArrayList<I18nMessage>();
        String reg = "^[A-Za-z0-9_.]+$";
        String reg1 = "^[A-Za-z0-9-]+$";
        boolean isEmptyExcel = true;
        for (int j = 0; j < wb.getNumberOfSheets(); ++j) {
            Row row;
            int i;
            Sheet sheet = wb.getSheetAt(j);
            if (sheet.getPhysicalNumberOfRows() <= 1) continue;
            isEmptyExcel = false;
            HashMap<String, Integer> headMap = new HashMap<String, Integer>();
            for (i = 0; i < sheet.getRow(0).getLastCellNum(); ++i) {
                row = sheet.getRow(0);
                headMap.put(row.getCell(i).getStringCellValue().trim(), i);
            }
            for (i = 1; i < sheet.getPhysicalNumberOfRows(); ++i) {
                I18nMessage m;
                row = sheet.getRow(i);
                String messageKey = this.getCellValue(row, headMap, "\u56fd\u9645\u5316\u8d44\u6e90key", j, i, 255);
                String messageValue = this.getCellValue(row, headMap, "\u56fd\u9645\u5316\u8d44\u6e90\u503c", j, i, 512);
                String messageType = this.getCellValue(row, headMap, "\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b", j, i, 30);
                String messageDesc = this.getCellValue(row, headMap, "\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b\u8bf4\u660e", j, i, 64);
                if (!messageKey.matches(reg)) {
                    throw new RuntimeException("Excel\u8868\u683c\u7b2c" + (j + 1) + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c" + (i + 1) + "\u884c\u3010\u56fd\u9645\u5316\u8d44\u6e90key\u3011\u4e0d\u7b26\u5408\u89c4\u5b9a\uff0c\u53ea\u80fd\u662f\u6570\u5b57,\u5b57\u6bcd,\u70b9,\u4e0b\u5212\u7ebf\u7ec4\u6210\uff01");
                }
                if (!messageType.matches(reg1)) {
                    throw new RuntimeException("Excel\u8868\u683c\u7b2c" + (j + 1) + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c" + (i + 1) + "\u884c\u3010\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b\u3011\u4e0d\u7b26\u5408\u89c4\u5b9a\uff0c\u53ea\u80fd\u662f\u6570\u5b57,\u5b57\u6bcd\u6216-\u7ec4\u6210\uff01");
                }
                I18nMessageType t = this.i18nMessageTypeManager.getByType(messageType);
                if (BeanUtils.isEmpty((Object)((Object)t))) {
                    t = new I18nMessageType();
                    t.setId(UniqueIdUtil.getSuid());
                    t.setType(messageType);
                    t.setDesc(messageDesc);
                    this.dealTypeList(typeList, t);
                }
                if (BeanUtils.isEmpty((Object)((Object)(m = this.i18nMessageDao.getByKeyAndType(messageKey, messageType))))) {
                    m = new I18nMessage();
                    m.setId(UniqueIdUtil.getSuid());
                    m.setKey(messageKey);
                    m.setType(messageType);
                    m.setValue(messageValue);
                    this.dealMessageList(messageAddList, m);
                    continue;
                }
                m.setValue(messageValue);
                messageUpdateList.add(m);
            }
        }
        if (isEmptyExcel) {
            result = false;
            console = "\u6587\u4ef6\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25";
            throw new RuntimeException(console);
        }
        for (I18nMessageType type : typeList) {
            this.i18nMessageTypeManager.create((Model)type);
        }
        for (I18nMessage message : messageAddList) {
            this.i18nMessageDao.insert((Object)message);
        }
        for (I18nMessage message : messageUpdateList) {
            this.i18nMessageDao.updateById((Object)message);
        }
        rtnMap.put("result", result);
        rtnMap.put("console", console);
        return rtnMap;
    }

    public String getCellValue(Row row, Map<String, Integer> headMap, String key, int j, int i, int maxLength) {
        String val = "";
        ++j;
        boolean required = !"\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b\u8bf4\u660e".equals(key);
        try {
            if (headMap.get(key) == null) {
                if (required) {
                    throw new RuntimeException("Excel\u8868\u683c\u7b2c" + j + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c\u7f3a\u5c11\u5fc5\u586b\u7684\u5217\u3010" + key + "\u3011");
                }
            } else if (row.getCell(headMap.get(key).intValue()) == null) {
                if (required) {
                    throw new RuntimeException("Excel\u8868\u683c\u7b2c" + j + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c" + (i + 1) + "\u884c\u3010" + key + "\u3011\u5fc5\u586b\uff01");
                }
            } else {
                val = row.getCell(headMap.get(key).intValue()).getStringCellValue().trim();
                if (BeanUtils.isEmpty((Object)val)) {
                    val = "";
                }
                if (required && "".equals(val)) {
                    throw new RuntimeException("Excel\u8868\u683c\u7b2c" + j + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c" + (i + 1) + "\u884c\u3010" + key + "\u3011\u5fc5\u586b\uff01");
                }
            }
            if (val.length() > maxLength) {
                throw new RuntimeException("Excel\u8868\u683c\u7b2c" + j + "\u4e2a\u5de5\u4f5c\u7c3f\u7b2c" + (i + 1) + "\u884c\u3010" + key + "\u3011\u957f\u5ea6\u8fc7\u957f,\u6700\u5927\u957f\u5ea6" + maxLength + "\uff01");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return val;
    }

    private void dealTypeList(List<I18nMessageType> list, I18nMessageType t) {
        I18nMessageType type;
        if (list.size() == 0) {
            list.add(t);
        }
        for (int j = 0; j < list.size() && !(type = list.get(j)).getType().equals(t.getType()); ++j) {
            if (j != list.size() - 1 || type.getId().equals(t.getId()) || type.getType().equals(t.getType())) continue;
            list.add(t);
        }
    }

    private void dealMessageList(List<I18nMessage> list, I18nMessage m) {
        I18nMessage msg;
        if (list.size() == 0) {
            list.add(m);
        }
        for (int j = 0; !(j >= list.size() || (msg = list.get(j)).getType().equals(m.getType()) && msg.getKey().equals(m.getKey())); ++j) {
            if (j != list.size() - 1 || msg.getKey().equals(m.getKey()) && msg.getType().equals(m.getType())) continue;
            list.add(m);
        }
    }

    @Override
    public HSSFWorkbook exportExcel() throws Exception {
        List<Map<String, String>> pageList = this.i18nMessageDao.getI18nInfo();
        if (BeanUtils.isEmpty(pageList)) {
            throw new RuntimeException("\u6ca1\u6709\u56fd\u9645\u5316\u8d44\u6e90\uff0c\u65e0\u6cd5\u8fdb\u884c\u5bfc\u51fa\u64cd\u4f5c\uff01");
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (String key : pageList.get(0).keySet()) {
            if ("ID_".equals(key)) continue;
            if ("KEY_".equals(key)) {
                fieldMap.put("KEY_", "\u56fd\u9645\u5316\u8d44\u6e90key");
            }
            if ("VALUE_".equals(key)) {
                fieldMap.put("VALUE_", "\u56fd\u9645\u5316\u8d44\u6e90\u503c");
            }
            if ("TYPE_".equals(key)) {
                fieldMap.put("TYPE_", "\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b");
            }
            if (!"DESC_".equals(key)) continue;
            fieldMap.put("DESC_", "\u56fd\u9645\u5316\u8bed\u8a00\u7c7b\u578b\u8bf4\u660e");
        }
        String title = "\u56fd\u9645\u5316\u8d44\u6e90\u5217\u8868";
        return ExcelUtil.exportExcel((String)title, (int)24, fieldMap, pageList);
    }

    @Override
    public List<Map<String, String>> getSearchList(String val) {
        List typeList = this.i18nMessageTypeManager.list();
        ArrayList<String> types = new ArrayList<String>();
        for (I18nMessageType type : typeList) {
            types.add(type.getType());
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("types", types);
        if (StringUtil.isNotEmpty((String)val)) {
            params.put("val", "%" + val + "%");
        }
        return this.i18nMessageDao.searchList(params);
    }
}

