/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bo.instance.impl;

import com.artfess.bo.instance.BoDataHandler;
import com.artfess.bo.instance.BoInstanceFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="boInstanceFactory")
public class BoInstanceFactoryImpl
implements BoInstanceFactory {
    @Autowired
    ApplicationContext context;
    private Map<String, BoDataHandler> handlerMap = new HashMap<String, BoDataHandler>();

    public void setHandlerList(List<BoDataHandler> list) {
        for (BoDataHandler handler : list) {
            this.handlerMap.put(handler.saveType(), handler);
        }
    }

    @Override
    public BoDataHandler getBySaveType(String saveType) {
        if (this.handlerMap.size() == 0) {
            this.handlerMap = this.context.getBeansOfType(BoDataHandler.class);
        }
        for (String in : this.handlerMap.keySet()) {
            BoDataHandler handler = this.handlerMap.get(in);
            if (!handler.saveType().equals(saveType)) continue;
            return handler;
        }
        return null;
    }
}

