/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class TenantUtil {
    private static Log logger = LogFactory.getLog(TenantUtil.class);

    public static void initData(String tenantId, List<String> tableNames) {
        JdbcTemplate jdbcTemplate = AppUtil.getBean(JdbcTemplate.class);
        logger.debug((Object)"\u5f00\u59cb\u521d\u59cb\u5316\u79df\u6237\u7684\u6570\u636e");
        for (String tableName : tableNames) {
            String sql = String.format("select * from %s where tenant_id_ = '%s'", tableName, "-1");
            if ("portal_sys_type".equals(tableName)) {
                sql = sql + String.format(" and type_key_ = '%s'", "default");
            } else if ("uc_demension".equals(tableName)) {
                sql = sql + String.format(" and code_ = '%s'", "xzwd");
            } else if ("portal_news_tree_".equals(tableName)) {
                sql = sql + String.format(" and parent_id_ = '%s'", "0");
            }
            List queryForList = jdbcTemplate.queryForList(sql);
            ArrayList<String> updateSqls = new ArrayList<String>();
            for (Map map : queryForList) {
                String dhUpdateSql;
                int subLength;
                Iterator iter = map.entrySet().iterator();
                ArrayList<String> fields = new ArrayList<String>();
                ArrayList<Object> params = new ArrayList<Object>();
                Object id = null;
                int longtextIndex = -1;
                while (iter.hasNext()) {
                    String lowerCase;
                    Map.Entry entry = iter.next();
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    switch (lowerCase = key.toLowerCase()) {
                        case "id_": {
                            value = UniqueIdUtil.getSuid();
                            id = value;
                            break;
                        }
                        case "id": {
                            value = UniqueIdUtil.getSuid();
                            break;
                        }
                        case "tenant_id_": {
                            value = tenantId;
                            break;
                        }
                        case "path_": {
                            if (!tableName.equals("portal_sys_type")) break;
                            value = String.valueOf(value).split("\\.")[0] + "." + id + ".";
                        }
                    }
                    if (!BeanUtils.isNotEmpty(value) || value instanceof Date) continue;
                    fields.add(key);
                    if (value instanceof String) {
                        value = "'" + value + "'";
                    }
                    params.add(value);
                    if (value.toString().length() <= 4000) continue;
                    longtextIndex = params.size() - 1;
                }
                String updateSql = "";
                if ("portal_sys_layout_manage".equals(tableName) && params.get(2).toString().length() > 4000) {
                    int subNum = 3000;
                    String design_html = params.get(2).toString();
                    params.set(2, params.get(2).toString().substring(0, subNum) + "'");
                    updateSql = String.format("insert into %s(%s) values(%s)", tableName, Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
                    updateSqls.add(updateSql);
                    int subIndex = (design_html.length() - subNum) / subNum + 1;
                    for (int i = 1; i <= subIndex; ++i) {
                        subLength = subNum * (i + 1);
                        if (i == subIndex) {
                            subLength = design_html.length() - 1;
                        }
                        dhUpdateSql = String.format("update portal_sys_layout_manage set DESIGN_HTML = concat(DESIGN_HTML,%s) where ID = %s", "'" + design_html.substring(subNum * i, subLength) + "'", params.get(0));
                        updateSqls.add(dhUpdateSql);
                    }
                    continue;
                }
                if ("portal_sys_column".equals(tableName) && longtextIndex > -1) {
                    int subNum = 3000;
                    String template_html = params.get(longtextIndex).toString();
                    params.set(longtextIndex, params.get(longtextIndex).toString().substring(0, subNum) + "'");
                    updateSql = String.format("insert into %s(%s) values(%s)", tableName, Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
                    updateSqls.add(updateSql);
                    int subIndex = (template_html.length() - subNum) / subNum + 1;
                    for (int i = 1; i <= subIndex; ++i) {
                        subLength = subNum * (i + 1);
                        if (i == subIndex) {
                            subLength = template_html.length() - 1;
                        }
                        dhUpdateSql = String.format("update portal_sys_column set TEMPLATE_HTML = concat(TEMPLATE_HTML,%s) where ID = %s", "'" + template_html.substring(subNum * i, subLength) + "'", params.get(0));
                        updateSqls.add(dhUpdateSql);
                    }
                    continue;
                }
                updateSql = String.format("insert into %s(%s) values(%s)", tableName, Joiner.on((String)",").join(fields), Joiner.on((String)",").join(params));
                updateSqls.add(updateSql);
                if (!"portal_sys_column".equals(tableName)) continue;
                String addAuthSql = "INSERT INTO portal_sys_auth_user (id_, obj_type_, authorize_id_, right_type_, tenant_id_) VALUES ('" + UniqueIdUtil.getSuid() + "', 'indexColumn', " + params.get(0).toString() + ", 'everyone', '" + tenantId + "')";
                updateSqls.add(addAuthSql);
            }
            if (!BeanUtils.isNotEmpty(updateSqls) || updateSqls.size() <= 0) continue;
            for (String insertSql : updateSqls) {
                jdbcTemplate.update(insertSql);
            }
        }
    }
}

