/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.dw.manager.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataResource.dw.dao.BizDwTableDao;
import com.artfess.dataShare.dataResource.dw.manager.BizDwFieldManager;
import com.artfess.dataShare.dataResource.dw.manager.BizDwTableManager;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTable;
import com.artfess.dataShare.dataResource.dw.model.BizDwdCatalogsTableField;
import com.artfess.dataShare.dataResource.dw.vo.BizDwTableVo;
import com.artfess.dataShare.dataResource.dw.vo.DwTableDetailVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import com.artfess.dataShare.util.EasyExcelUtil;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizDwTableManagerImpl
extends BaseManagerImpl<BizDwTableDao, BizDwdCatalogsTable>
implements BizDwTableManager {
    @Resource
    BizDwTableManager dwTableManager;
    @Resource
    BizDwFieldManager dwFieldManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String catalogId) throws Exception {
        ExcelTool util = new ExcelTool(BizDwTableVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(3), Integer.valueOf(4));
        for (BizDwTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getTableNameCh())) continue;
            if (StringUtil.isEmpty((String)vo.getTableNameCh())) {
                throw new BaseException("\u8868" + vo.getName() + "\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)vo.getTableNameEn())) {
                throw new BaseException("\u8868" + vo.getName() + "\u82f1\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!this.checkTable(vo.getCode())) continue;
            throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getCode() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
        }
        for (BizDwTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getCode())) continue;
            BizDwdCatalogsTable table = BizDwTableVo.parseTable(vo);
            table.setDwCatalogsId(catalogId);
            table.setIsCreateTable("0");
            table.setDeployed("0");
            table.setTableNameEn("dw_" + table.getTableNameEn());
            this.create((Model)table);
        }
    }

    public boolean checkTable(String tableName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)tableName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizDwdCatalogsTable dwTable = (BizDwdCatalogsTable)((Object)this.dwTableManager.getById((Serializable)((Object)tableId)));
        List<BizDwdCatalogsTableField> field = this.dwFieldManager.queryFieldByTableId(tableId);
        if (field.size() == 0) {
            throw new ApplicationException("\u8d44\u6e90\u8868\u672a\u8bbe\u7f6e\u5b57\u6bb5\u3002");
        }
        if ("1".equalsIgnoreCase(dwTable.getTableClass())) {
            LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
            for (BizDwdCatalogsTableField field1 : field) {
                if (!"2".equals(field1.getFieldType())) continue;
                exportMap.put(field1.getName(), field1.getDesc());
            }
            HSSFWorkbook book = ExcelUtil.exportExcel((String)dwTable.getName(), (int)12, exportMap, new ArrayList(), (int)0);
            ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(dwTable.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
        } else if ("2".equalsIgnoreCase(dwTable.getTableClass())) {
            ArrayList head = new ArrayList();
            ArrayList<String> defaultName = new ArrayList<String>();
            defaultName.add(dwTable.getName() + "-" + dwTable.getTableNameEn());
            defaultName.add("\u4e2a\u4eba\u59d3\u540d-USER_NAME_");
            head.add(defaultName);
            ArrayList<String> defaultSex = new ArrayList<String>();
            defaultSex.add(dwTable.getName() + "-" + dwTable.getTableNameEn());
            defaultSex.add("\u4e2a\u4eba\u6027\u522b-USER_SEX_");
            head.add(defaultSex);
            ArrayList<String> defaultCard = new ArrayList<String>();
            defaultCard.add(dwTable.getName() + "-" + dwTable.getTableNameEn());
            defaultCard.add("\u8eab\u4efd\u8bc1\u53f7-USER_IDENTITY_CARD_");
            head.add(defaultCard);
            ArrayList<String> defaultPhone = new ArrayList<String>();
            defaultPhone.add(dwTable.getName() + "-" + dwTable.getTableNameEn());
            defaultPhone.add("\u79fb\u52a8\u624b\u673a\u53f7-USER_PHONE_");
            head.add(defaultPhone);
            for (BizDwdCatalogsTableField field1 : field) {
                if ("1".equals(field1.getFieldType())) continue;
                String headStr = field1.getName() + "-" + field1.getFieldCode();
                ArrayList<String> fieldHead = new ArrayList<String>();
                fieldHead.add(dwTable.getName() + "-" + dwTable.getTableNameEn());
                fieldHead.add(headStr);
                head.add(fieldHead);
            }
            String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String path = rootRealPath + File.separator + System.currentTimeMillis() + ".xls";
            System.out.println(path);
            ((ExcelWriterBuilder)EasyExcel.write((String)path).head(head)).sheet().doWrite(new ArrayList());
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)path, (String)path);
        }
    }

    @Override
    @Transactional
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizDwdCatalogsTable dwTable = (BizDwdCatalogsTable)((Object)this.dwTableManager.getById((Serializable)((Object)tableId)));
        if ("1".equals(dwTable.getTableClass())) {
            this.importWExcelData(file, dwTable);
        } else if ("2".equals(dwTable.getTableClass())) {
            this.exportDExcelData(file, dwTable);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importWExcelData(MultipartFile file, BizDwdCatalogsTable dwTable) throws Exception {
        List<BizDwdCatalogsTableField> fieldLists = this.dwFieldManager.queryFieldByTableId(dwTable.getId());
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizDwdCatalogsTableField field : fieldLists) {
            nameFieldMap.put(field.getDesc(), field.getFieldCode());
        }
        List rows = ExcelUtil.ImportDate((MultipartFile)file);
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        for (Map row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            fields.add(BizDwdCatalogsTableField.PK_NAME);
            values.add("'" + UniqueIdUtil.getSuid() + "'");
            for (Map.Entry map : row.entrySet()) {
                if (!BeanUtils.isNotEmpty(map.getValue())) continue;
                String key = (String)map.getKey();
                String field = this.getFieldName(key, fieldLists, (String)nameFieldMap.get(key));
                fields.add(field);
                String dataType = this.getDataType(key, fieldLists, (String)nameFieldMap.get(key));
                if ("number".equals(dataType)) {
                    values.add("'" + (String)map.getValue() + "'");
                    continue;
                }
                values.add("'" + (String)map.getValue() + "'");
            }
            sql.append(dwTable.getTableNameEn());
            sql.append("(" + String.join((CharSequence)",", fields) + ")");
            sql.append(" values ");
            sql.append("(" + String.join((CharSequence)",", values) + ")");
            jdbcTemplate.execute(sql.toString());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void exportDExcelData(MultipartFile file, BizDwdCatalogsTable dwTable) throws Exception {
        List<Object> data = EasyExcelUtil.readMoreThan1000Row(file.getInputStream());
        List<BizDwdCatalogsTableField> fields = this.dwFieldManager.queryFieldByTableId(dwTable.getId());
        fields = fields.stream().filter(p -> p.getFieldType().equals("2")).collect(Collectors.toList());
        Map<String, BizDwdCatalogsTableField> fieldMap = fields.stream().collect(Collectors.toMap(p -> p.getFieldCode(), p -> p));
        JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        String tableName = dwTable.getTableNameEn().replace("dw_", "");
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        String uId = user.getUserId();
        String tenantId = user.getTenantId();
        String orgId = org.getGroupId();
        String insertDsql = "insert into DWD_BIZ_" + tableName + "_DATA(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_," + "USER_PHONE_,DATA_ID_,DATA_JSON_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" + " values(?,?,?,?,?,?,?,?,?,?,?,?,now(),?)";
        String recordTable = "DWD_" + tableName + "_TABLE_RECORD";
        String insertSql = "insert into " + recordTable + "(id_,user_id_,user_name_,USER_SEX_,USER_IDENTITY_CARD_,USER_PHONE_,DATA_ID_," + "FIELD_ID_,FIELD_CODE_,FIELD_VALUE_,FIELD_UI_MODULE_,FIELD_VALUE_TIME_,VERSION,CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_,TENANT_ID_)" + " values (?,?,?,?,?,?,?, ?,?,?,?,?,?,?,?,now(),?)";
        ArrayList<Object[]> dDataList = new ArrayList<Object[]>();
        ArrayList<Object[]> rDataList = new ArrayList<Object[]>();
        ArrayList<String> fieldList = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            List rows = (List)data.get(i);
            if (i == 0) {
                String string = (String)rows.get(0);
                continue;
            }
            if (i == 1) {
                for (String field : rows) {
                    String fieldName = field.substring(field.indexOf("-") + 1);
                    fieldList.add(fieldName);
                }
                continue;
            }
            String pcId = UniqueIdUtil.getSuid();
            JSONObject jsonObject = new JSONObject();
            String userName = (String)rows.get(0);
            String userSex = (String)rows.get(1);
            String userIdentityCard = (String)rows.get(2);
            String userPhone = (String)rows.get(3);
            for (int j = 4; j < rows.size(); ++j) {
                String value = (String)rows.get(j);
                jsonObject.put(fieldMap.get(fieldList.get(j)).getFieldCode(), (Object)value);
            }
            ArrayList<Object> dParam = new ArrayList<Object>();
            dParam.add(UniqueIdUtil.getSuid());
            dParam.add("");
            dParam.add(userName);
            dParam.add(userSex);
            dParam.add(userIdentityCard);
            dParam.add(userPhone);
            dParam.add(pcId);
            dParam.add(jsonObject.toJSONString());
            dParam.add(LocalDateTime.now());
            dParam.add(1);
            dParam.add(uId);
            dParam.add(orgId);
            dParam.add(tenantId);
            dDataList.add(dParam.toArray());
            for (int j = 4; j < rows.size(); ++j) {
                String value = (String)rows.get(j);
                BizDwdCatalogsTableField tableField = fieldMap.get(fieldList.get(j));
                ArrayList<Object> rParam = new ArrayList<Object>();
                rParam.add(UniqueIdUtil.getSuid());
                rParam.add("1");
                rParam.add(userName);
                rParam.add(userSex);
                rParam.add(userIdentityCard);
                rParam.add(userPhone);
                rParam.add(pcId);
                rParam.add(tableField.getId());
                rParam.add(tableField.getFieldCode());
                rParam.add(value);
                rParam.add(tableField.getUiComCode());
                rParam.add(LocalDateTime.now());
                rParam.add(1);
                rParam.add(uId);
                rParam.add(orgId);
                rParam.add(tenantId);
                rDataList.add(rParam.toArray());
            }
        }
        jdbcTemplate.batchUpdate(insertDsql, dDataList);
        jdbcTemplate.batchUpdate(insertSql, rDataList);
    }

    private String getFieldName(String key, List<BizDwdCatalogsTableField> columnList, String fieldName) {
        for (BizDwdCatalogsTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldCode();
        }
        return "";
    }

    private String getDataType(String key, List<BizDwdCatalogsTableField> columnList, String fieldName) {
        for (BizDwdCatalogsTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void Deploy(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        String tableDesc = table.getTableDesc() == null ? table.getTableNameCh() : table.getTableDesc();
        String tableName = table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        List<BizDwdCatalogsTableField> fieldList = this.dwFieldManager.queryFieldByTableId(tableId);
        if (fieldList.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        if ("1".equals(table.getTableClass())) {
            if ("1".equals(table.getDeployed())) {
                for (BizDwdCatalogsTableField field : fieldList) {
                    if ("1".equals(field.getIsCreate())) continue;
                    field.setIsCreate("1");
                    Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
                    Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
                    String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                    field.setDecimalLen(decimalLen);
                    field.setFlSql(fieldSq);
                    template.execute(fieldSq);
                }
                this.dwFieldManager.updateBatchById(fieldList);
            } else {
                for (BizDwdCatalogsTableField field : fieldList) {
                    field.setIsCreate("1");
                    Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
                    Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
                    String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldCode() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                    field.setDecimalLen(decimalLen);
                    field.setFlSql(fieldSq);
                }
                this.dwFieldManager.updateBatchById(fieldList);
                table.setIsCreateTable("1");
                table.setCode(table.getTableNameEn());
                table.setDeployed("1");
                table.setDeployedTime(LocalDateTime.now());
                String createSql = DorisUtils.createDwTable(template, table.getTableNameEn(), tableDesc, fieldList);
                table.setCreateTableSql(createSql);
                this.update((Model)table);
            }
        } else {
            if (!"1".equals(table.getDeployed())) {
                tableName = tableName.replace("dw_", "");
                DorisUtils.createDwTable(template, tableName, tableDesc);
                table.setIsCreateTable("1");
                table.setCreateTableSql(DorisUtils.queryDwdMainSql(tableName, tableDesc));
                table.setCreateTableDSql(DorisUtils.queryDwdDetailSql(tableName, tableDesc));
                table.setCode(table.getTableNameEn());
                table.setDeployed("1");
                table.setDeployedTime(LocalDateTime.now());
                this.update((Model)table);
            }
            for (BizDwdCatalogsTableField field : fieldList) {
                if ("1".equals(field.getIsCreate())) continue;
                field.setIsCreate("1");
            }
            this.dwFieldManager.updateBatchById(fieldList);
        }
    }

    @Override
    public DwTableDetailVo queryTableVo(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        DwTableDetailVo vo = new DwTableDetailVo();
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if (null == table) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u8868");
        }
        vo.setTable(table);
        vo.setFieldList(this.dwFieldManager.queryFieldByTableId(tableId));
        return vo;
    }

    @Override
    public QueryResultData queryTableData(QueryParamVo queryParamVo) throws Exception {
        Assert.hasText((String)queryParamVo.getTableId(), (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizDwdCatalogsTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizDwdCatalogsTable)((Object)((BizDwTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizDwdCatalogsTableField> fieldList = this.dwFieldManager.queryFieldByTableId(table.getId());
        Map<String, String> field = fieldList.stream().filter(p -> "2".equals(p.getFieldType())).collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p -> p.getName()));
        if (queryParam.getPageNo() == 0) {
            field = fieldList.stream().collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p -> p.getName()));
        }
        field.put("id_", "\u4e3b\u952e");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType("mysql");
        return QueryDataTableFactory.getTableData(queryParam);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTable(String tableId) throws Exception {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        if ("1".equals(table.getDeployed()) && "1".equals(table.getTableClass())) {
            boolean exists = this.checkPhysicsTableExists(table.getTableNameEn());
            if (exists) {
                String dropSql = "drop table " + table.getTableNameEn();
                JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
                template.execute(dropSql);
            }
        } else if ("1".equals(table.getDeployed()) && "1".equals(table.getTableClass())) {
            boolean recordExists;
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
            String dataTable = "DWD_BIZ_" + table.getTableNameEn() + "_DATA";
            String recordTable = "DWD_" + table.getTableNameEn() + "_TABLE_RECORD";
            boolean mainExists = this.checkPhysicsTableExists(table.getTableNameEn());
            if (mainExists) {
                String dropSql = "drop table " + dataTable;
                template.execute(dropSql);
            }
            if (recordExists = this.checkPhysicsTableExists(table.getTableNameEn())) {
                String dropSql1 = "drop table " + recordTable;
                template.execute(dropSql1);
            }
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        this.removeById((Serializable)((Object)tableId));
        this.dwFieldManager.remove((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public QueryResultData queryDTTableData(QueryParamVo queryParamVo) throws Exception {
        if (StringUtil.isEmpty((String)queryParamVo.getTableId()) && StringUtil.isEmpty((String)queryParamVo.getTableName())) {
            throw new ApplicationException("\u8868ID\u6216\u8005\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizDwdCatalogsTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizDwdCatalogsTable)((Object)((BizDwTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        queryParam.setTableName(table.getTableNameEn());
        List<BizDwdCatalogsTableField> fieldList = this.dwFieldManager.queryFieldByTableId(table.getId());
        Map<String, String> field = fieldList.stream().filter(p -> "2".equals(p.getFieldType())).collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p -> p.getName()));
        field.put("id_", "\u4e3b\u952e");
        if (queryParam.getPageNo() == 0) {
            field = fieldList.stream().collect(Collectors.toMap(BizDwdCatalogsTableField::getFieldCode, p -> p.getName()));
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        Integer pageNo = queryParamVo.getPageNo();
        Integer pageSize = queryParamVo.getPageSize();
        String order = queryParamVo.getOrder();
        String tableName = table.getTableNameEn();
        Map<String, String> paramMap = queryParamVo.getParam();
        tableName = tableName.replace("dw_", "");
        QueryResultData resultData = new QueryResultData();
        String querySql = "select * from DWD_BIZ_" + tableName + "_DATA where 1=1";
        String querySqlCount = "select count(*) from DWD_BIZ_" + tableName + "_DATA where 1=1";
        for (String key : paramMap.keySet()) {
            querySql = querySql + " and " + key + " = '" + paramMap.get(key) + "'";
            querySqlCount = querySqlCount + " and " + key + " = '" + paramMap.get(key) + "'";
        }
        if (pageNo > 0) {
            int total = (Integer)template.queryForObject(querySqlCount, Integer.class);
            resultData.setTotal(total);
        }
        querySql = StringUtil.isNotEmpty((String)order) ? querySql + " order by " + order : querySql + " order by create_time_";
        if (pageNo > 1) {
            querySql = querySql + " limit " + (pageNo - 1) * pageSize + "," + pageSize;
        }
        resultData.setData(template.queryForList(querySql));
        resultData.setField(field);
        return resultData;
    }

    @Override
    public Map<String, Object> queryTableDetailData(String tableId, String pcId) throws Exception {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)((Object)this.getById((Serializable)((Object)tableId)));
        String tableName = table.getTableNameEn().replace("dw_", "");
        List<BizDwdCatalogsTableField> fieldList = this.dwFieldManager.queryFieldByTableId(tableId);
        String querySql = "select * from DWD_" + tableName + "_TABLE_RECORD where DATA_ID_= ? ";
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        List data = template.queryForList(querySql, new Object[]{pcId});
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("data", data);
        result.put("field", fieldList);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployHaveTable(String tableId) throws Exception {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)this.get((Serializable)((Object)tableId));
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        this.update((Model)table);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deployDotHaveTable(String tableId, String tableSql, String detailTableSql) throws Exception {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)this.get((Serializable)((Object)tableId));
        List<BizDwdCatalogsTableField> tableFields = this.dwFieldManager.queryFieldByTableId(tableId);
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (tableFields.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        table.setCreateTableSql(tableSql);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        table.setIsCreateTable("1");
        table.setDeployed("1");
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        if ("2".equals(table.getTableClass())) {
            table.setCreateTableDSql(detailTableSql);
            template.execute(table.getCreateTableDSql());
        }
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
    }

    @Override
    public boolean checkTableExists(String tableNameEn) throws Exception {
        String sql;
        tableNameEn = "dw_" + tableNameEn.replaceFirst("dw_", "");
        if (this.checkTable(tableNameEn)) {
            return true;
        }
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public boolean checkPhysicsTableExists(String tableNameEn) throws Exception {
        String sql;
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)"dwd");
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    public Map<String, String> queryDwTable(String tableId) {
        BizDwdCatalogsTable table = (BizDwdCatalogsTable)this.get((Serializable)((Object)tableId));
        HashMap<String, String> result = new HashMap<String, String>();
        String dwdMainSql = DorisUtils.queryDwdMainSql(table.getTableNameEn(), table.getTableDesc());
        String dwdDetailSql = DorisUtils.queryDwdDetailSql(table.getTableNameEn(), table.getTableDesc());
        result.put("dwdMainSql", dwdMainSql);
        result.put("dwdDetailSql", dwdDetailSql);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateCatalog(String[] ids, String catalogId) {
        int count = ((BizDwTableDao)this.baseMapper).updateCatalog(ids, catalogId);
        return count > 0;
    }
}

