/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.def;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.persistence.manager.ActExecutionManager;
import com.artfess.bpm.persistence.model.ActExecution;
import com.artfess.bpm.util.ClassLoadUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.springframework.transaction.TransactionSystemException;

public class BpmDefUtil {
    public static String transBpmDef(String id, String name, String xml) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            InputStream is = loader.getResourceAsStream("com/artfess/bpmx/activiti/xml/transformDef.xsl");
            if (is == null) {
                is = BpmDefUtil.class.getResourceAsStream("com/artfess/bpmx/activiti/xml/transformDef.xsl");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", id);
            map.put("name", name);
            String result = Dom4jUtil.transXmlByXslt((String)xml, (InputStream)is, map);
            result = result.replace("&lt;", "<").replace("&gt;", ">").replace("xmlns=\"\"", "").replace("&amp;", "&");
            return result;
        }
        catch (Exception ex) {
            throw new TransactionSystemException("\u8f6c\u6362\u6d41\u7a0b\u5b9a\u4e49\u51fa\u9519", (Throwable)ex);
        }
    }

    public static String transFlashBpmDef(String id, String name, String xml) throws Exception {
        return ClassLoadUtil.transform((String)id, (String)name, (String)xml);
    }

    public static Map<String, Object> prepare(String actDefId, String nodeId, String[] aryDestination) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        RepositoryService repositoryService = (RepositoryService)AppUtil.getBean(RepositoryService.class);
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)repositoryService).getDeployedProcessDefinition(actDefId);
        ActivityImpl curAct = processDefinition.findActivity(nodeId);
        List outTrans = curAct.getOutgoingTransitions();
        ActivityImpl cloneCurAct = null;
        try {
            cloneCurAct = (ActivityImpl)FileUtil.cloneObject((Object)curAct);
            List cloneOutTrans = (List)FileUtil.cloneObject((Object)outTrans);
            map.put("outTrans", cloneOutTrans);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (PvmTransition transition : outTrans) {
            PvmActivity activity = transition.getDestination();
            List inTrans = activity.getIncomingTransitions();
            Iterator itIn = inTrans.iterator();
            while (itIn.hasNext()) {
                PvmTransition inTransition = (PvmTransition)itIn.next();
                if (!inTransition.getSource().getId().equals(curAct.getId())) continue;
                itIn.remove();
            }
        }
        curAct.getOutgoingTransitions().clear();
        if (aryDestination != null && aryDestination.length > 0) {
            for (String dest : aryDestination) {
                ActivityImpl destAct = processDefinition.findActivity(dest);
                ActionCmd cmd = ContextThreadUtil.getActionCmd();
                if (BeanUtils.isNotEmpty((Object)cmd) && BeanUtils.isNotEmpty((Object)cmd.getTransitVars("bpmTask_")) && "normal".equals(cmd.getTransitVars("backHandMode"))) {
                    TransitionImpl transitionImpl;
                    ActivityImpl gateWayAct;
                    String afterGateWayActId;
                    HashMap<String, Object> gateWayMap = new HashMap<String, Object>();
                    if (BpmDefUtil.inInclusiveOrParallelGateway(cloneCurAct, NodeType.INCLUSIVEGATEWAY.getKey(), dest, gateWayMap)) {
                        afterGateWayActId = String.valueOf(gateWayMap.get("gateWayNodeId"));
                        gateWayAct = processDefinition.findActivity(afterGateWayActId);
                        gateWayAct.getOutgoingTransitions().clear();
                        transitionImpl = gateWayAct.createOutgoingTransition();
                        transitionImpl.setDestination(destAct);
                        destAct = gateWayAct;
                        BpmDefUtil.updateRejectExecution(cmd, afterGateWayActId);
                    }
                    if (BpmDefUtil.inInclusiveOrParallelGateway(cloneCurAct, NodeType.PARALLELGATEWAY.getKey(), dest, gateWayMap)) {
                        afterGateWayActId = String.valueOf(gateWayMap.get("gateWayNodeId"));
                        gateWayAct = processDefinition.findActivity(afterGateWayActId);
                        gateWayAct.getOutgoingTransitions().clear();
                        transitionImpl = gateWayAct.createOutgoingTransition();
                        transitionImpl.setDestination(destAct);
                        destAct = gateWayAct;
                        BpmDefUtil.updateRejectExecution(cmd, afterGateWayActId);
                    }
                }
                TransitionImpl transitionImpl = curAct.createOutgoingTransition();
                transitionImpl.setDestination(destAct);
            }
        }
        map.put("activity", curAct);
        return map;
    }

    public static void restore(Map<String, Object> map) {
        ActivityImpl curAct = (ActivityImpl)map.get("activity");
        List outTrans = (List)map.get("outTrans");
        curAct.getOutgoingTransitions().clear();
        curAct.getOutgoingTransitions().addAll(outTrans);
    }

    public static boolean inInclusiveOrParallelGateway(ActivityImpl curAct, String nodeType, String destNodeId, Map<String, Object> gatewayMap) {
        gatewayMap.put("hasGateWay", false);
        Boolean preHasGateway = false;
        Boolean afterHasGateway = false;
        HashSet<String> preNodeIds = new HashSet<String>();
        HashSet<String> afterNodeIds = new HashSet<String>();
        BpmDefUtil.hasGateWay(curAct.getIncomingTransitions(), "pre", nodeType, gatewayMap, preNodeIds);
        preHasGateway = (Boolean)gatewayMap.get("hasGateWay");
        gatewayMap.put("hasGateWay", false);
        BpmDefUtil.hasGateWay(curAct.getOutgoingTransitions(), "after", nodeType, gatewayMap, afterNodeIds);
        afterHasGateway = (Boolean)gatewayMap.get("hasGateWay");
        return preHasGateway != false && afterHasGateway != false && !preNodeIds.contains(destNodeId) && !afterNodeIds.contains(destNodeId);
    }

    public static void hasGateWay(List<PvmTransition> comingTransitions, String direction, String nodeType, Map<String, Object> gatewayMap, Set<String> nodeIds) {
        for (PvmTransition pvmTransition : comingTransitions) {
            if (((Boolean)gatewayMap.get("hasGateWay")).booleanValue()) continue;
            PvmActivity pvmActivity = null;
            if ("pre".equals(direction)) {
                pvmActivity = pvmTransition.getSource();
            }
            if ("after".equals(direction)) {
                pvmActivity = pvmTransition.getDestination();
            }
            if (nodeIds.contains(pvmActivity.getId())) continue;
            nodeIds.add(pvmActivity.getId());
            if (nodeType.equals(pvmActivity.getProperty("type"))) {
                gatewayMap.put("hasGateWay", true);
                gatewayMap.put("gateWayNodeId", pvmActivity.getId());
                continue;
            }
            List _comingTransitions = new ArrayList();
            if ("pre".equals(direction)) {
                _comingTransitions = pvmActivity.getIncomingTransitions();
            }
            if ("after".equals(direction)) {
                _comingTransitions = pvmActivity.getOutgoingTransitions();
            }
            BpmDefUtil.hasGateWay(_comingTransitions, direction, nodeType, gatewayMap, nodeIds);
        }
    }

    private static void updateRejectExecution(ActionCmd cmd, String afterGateWayActID) {
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        String execId = bpmTask.getExecId();
        ActExecutionManager actExecutionManager = (ActExecutionManager)AppUtil.getBean(ActExecutionManager.class);
        ActExecution actExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)execId));
        while (StringUtil.isNotEmpty((String)actExecution.getParentId()) && !actExecution.getParentId().equals(actExecution.getProcInstId())) {
            actExecution = (ActExecution)actExecutionManager.get((Serializable)((Object)actExecution.getParentId()));
            actExecutionManager.updateRejectExecution(actExecution.getParentId(), execId, actExecution.getActId());
        }
        actExecutionManager.updateRejectExecution(actExecution.getParentId(), execId, afterGateWayActID);
    }
}

