/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexLayoutManage;
import com.artfess.portal.model.SysObjRights;
import com.artfess.portal.persistence.dao.SysIndexLayoutManageDao;
import com.artfess.portal.persistence.manager.SysIndexLayoutManageManager;
import com.artfess.portal.persistence.manager.impl.SysIndexColumnManagerImpl;
import com.artfess.sysConfig.service.AuthorityManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="sysIndexLayoutManageManager")
public class SysIndexLayoutManageManagerImpl
extends BaseManagerImpl<SysIndexLayoutManageDao, SysIndexLayoutManage>
implements SysIndexLayoutManageManager {
    @Resource
    private SysIndexColumnManagerImpl sysIndexColumnService;
    @Resource
    private AuthorityManager authorityManager;
    @Resource
    BaseContext baseContext;

    @Override
    public SysIndexLayoutManage getLayoutList(String id, List<SysIndexColumn> columnList, Short type) {
        SysIndexLayoutManage sysIndexLayoutManage = null;
        if (StringUtil.isNotEmpty((String)id)) {
            sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        }
        if (BeanUtils.isEmpty(sysIndexLayoutManage)) {
            return this.getDefaultIndexLayout(type);
        }
        String designHtml = "";
        try {
            designHtml = Base64.getFromBase64((String)sysIndexLayoutManage.getDesignHtml());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        sysIndexLayoutManage.setDesignHtml(this.sysIndexColumnService.parserDesignHtml(designHtml, columnList));
        return sysIndexLayoutManage;
    }

    public String getDefaultMobileDesignHtml() {
        return "<div class=\"lyrow ui-draggable\" style=\"display: block;\"><div class=\"preview\"><input type=\"text\" value=\"\u4e00\u5217(12)\" readonly=\"readonly\" class=\"form-control\"></div><div class=\"view\"><div class=\"row clearfix\"><div class=\"col-md-12 column ui-sortable\"></div></div></div></div>";
    }

    @Override
    public String getDefaultDesignHtml() {
        return "<div class=\"lyrow ui-draggable\" style=\"display: block;\"><a href=\"#close\" class=\"remove label label-danger\"><i class=\"glyphicon-remove glyphicon\"></i> \u5220\u9664</a><span class=\"drag label label-default\"><i class=\"glyphicon glyphglyphicon glyphicon-move\"></i> \u62d6\u52a8</span><div class=\"preview\"><input type=\"text\" value=\"\u4e00\u5217(12)\" readonly=\"readonly\" class=\"form-control\"></div><div class=\"view\"><div class=\"row clearfix\"><div class=\"col-md-12 column ui-sortable\"></div></div></div></div>";
    }

    private SysIndexLayoutManage getDefaultIndexLayout(Short type) {
        String designHtml = this.getDefaultDesignHtml();
        if (type.equals((short)1)) {
            designHtml = this.getDefaultMobileDesignHtml();
        }
        SysIndexLayoutManage sysIndexLayoutManage = new SysIndexLayoutManage();
        sysIndexLayoutManage.setDesignHtml(designHtml);
        sysIndexLayoutManage.setIsDef((short)0);
        return sysIndexLayoutManage;
    }

    @Override
    public String getMyHasRightsLayout() {
        Map relationMap = this.authorityManager.getUserRightMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("relationMap", relationMap);
        params.put("objType", SysObjRights.RIGHT_TYPE_INDEX_MANAGE);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getByUserIdFilter(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getTemplateHtml();
        }
        return "";
    }

    @Override
    public String getManagerLayout() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", null);
        params.put("isDef", 1);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getManageLayout(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getDesignHtml();
        }
        return null;
    }

    @Override
    public String obtainIndexManageData(String layoutId) {
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)layoutId));
        if (BeanUtils.isNotEmpty((Object)((Object)sysIndexLayoutManage))) {
            return sysIndexLayoutManage.getTemplateHtml();
        }
        String html = this.getMyHasRightsLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        html = this.getManagerLayout();
        if (BeanUtils.isNotEmpty((Object)html)) {
            return html;
        }
        if (BeanUtils.isEmpty((Object)html)) {
            html = this.getDefaultDesignHtml();
        }
        return "";
    }

    @Override
    public SysIndexLayoutManage getEnableByOrgIdAndType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getEnableByOrgIdAndType(params);
    }

    @Override
    public Boolean isExistName(String name) {
        Integer count = ((SysIndexLayoutManageDao)this.baseMapper).isExistName(name);
        return count > 0;
    }

    @Override
    public List<SysIndexLayoutManage> getByOrgIdAndLayoutType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getByOrgIdAndLayoutType(params);
    }

    @Override
    public void cancelOrgIsDef(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        ((SysIndexLayoutManageDao)this.baseMapper).cancelOrgIsDef(params);
    }

    @Override
    public String obtainIndexManageMobileData(String layoutId) {
        SysIndexLayoutManage sysIndexLayoutManage = (SysIndexLayoutManage)this.get((Serializable)((Object)layoutId));
        return sysIndexLayoutManage.getTemplateHtml();
    }

    @Override
    public SysIndexLayoutManage getByIdAndType(String id, Short type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("type", type);
        return ((SysIndexLayoutManageDao)this.baseMapper).getByIdAndType(params);
    }

    @Override
    public String getMobileManagerLayout() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("layoutType", (short)1);
        params.put("orgIds", null);
        params.put("isDef", 1);
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getManageLayout(params);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0).getDesignHtml();
        }
        return null;
    }

    @Override
    public SysIndexLayoutManage getSharedByOrgIdAndType(String orgId, Short layoutType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("layoutType", layoutType);
        return ((SysIndexLayoutManageDao)this.baseMapper).getSharedByOrgIdAndType(params);
    }

    @Override
    public SysIndexLayoutManage getSharedByOrgIds(List<String> orgIds, Short layoutType) {
        List<SysIndexLayoutManage> list = ((SysIndexLayoutManageDao)this.baseMapper).getSharedByOrgIds(orgIds, layoutType);
        if (BeanUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public void setEnable(String id, Short enable) {
        SysIndexLayoutManage layout = (SysIndexLayoutManage)this.get((Serializable)((Object)id));
        if (enable == 1) {
            List<SysIndexLayoutManage> list = this.getByOrgIdAndLayoutType(layout.getOrgId(), layout.getLayoutType());
            for (SysIndexLayoutManage item : list) {
                if (item.getEnable() != 1) continue;
                item.setEnable((short)0);
                this.update((Model)item);
            }
        }
        layout.setEnable(enable);
        this.update((Model)layout);
    }

    @Override
    public SysIndexLayoutManage getDefaultLayoutManageByLayoutType(String layoutType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"LAYOUT_TYPE", (Object)Short.parseShort(layoutType))).eq((Object)"ENABLE", (Object)1)).eq((Object)"IS_DEF", (Object)1);
        SysIndexLayoutManage defaultLayout = (SysIndexLayoutManage)((Object)((SysIndexLayoutManageDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        return defaultLayout;
    }

    @Override
    public String exportDefaultLayout(List<String> ids, boolean isDefault) throws Exception {
        if (BeanUtils.isEmpty(ids)) {
            throw new BaseException("\u8bf7\u5148\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u9ed8\u8ba4\u5e03\u5c40");
        }
        QueryFilter queryFilter = QueryFilter.build();
        if (isDefault) {
            queryFilter.addFilter("IS_DEF", (Object)"1", QueryOP.EQUAL, FieldRelation.AND);
        } else {
            queryFilter.addFilter("IS_DEF", (Object)"0", QueryOP.EQUAL, FieldRelation.AND);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append(ids.get(i));
            if (i == ids.size() - 1) continue;
            sb.append(",");
        }
        queryFilter.addFilter("ID", (Object)sb.toString(), QueryOP.IN, FieldRelation.AND);
        PageList query = this.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)query.getRows())) {
            return JsonUtil.toJson((Object)query.getRows());
        }
        throw new BaseException("\u672a\u67e5\u627e\u5230\u4efb\u4f55\u8bb0\u5f55");
    }

    @Override
    @Transactional
    public void importFile(String uzPath, String orgId, boolean isDefault) {
        try {
            String fileName = isDefault ? "defaultLayout.json" : "orgLayout.json";
            String fileJson = FileUtil.readFile((String)(uzPath + File.separator + fileName));
            List list = (List)JsonUtil.toBean((String)fileJson, List.class);
            if (isDefault) {
                for (Object o : list) {
                    SysIndexLayoutManage layout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
                    SysIndexLayoutManage byId = (SysIndexLayoutManage)((Object)this.getById((Serializable)((Object)layout.getId())));
                    if (BeanUtils.isNotEmpty((Object)((Object)byId))) {
                        ((SysIndexLayoutManageDao)this.baseMapper).updateById((Object)layout);
                        continue;
                    }
                    ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)layout);
                }
            } else {
                if (StringUtil.isEmpty((String)orgId)) {
                    throw new BaseException("\u8bf7\u5148\u9009\u62e9\u90e8\u95e8");
                }
                for (Object o : list) {
                    SysIndexLayoutManage orgLayout = (SysIndexLayoutManage)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysIndexLayoutManage.class));
                    orgLayout.setOrgId(orgId);
                    SysIndexLayoutManage byId = (SysIndexLayoutManage)((Object)this.getById((Serializable)((Object)orgLayout.getId())));
                    if (BeanUtils.isNotEmpty((Object)((Object)byId))) {
                        if (StringUtil.equals((String)byId.getOrgId(), (String)orgId)) {
                            ((SysIndexLayoutManageDao)this.baseMapper).updateById((Object)orgLayout);
                            continue;
                        }
                        orgLayout.setId(UniqueIdUtil.getSuid());
                        ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)orgLayout);
                        continue;
                    }
                    ((SysIndexLayoutManageDao)this.baseMapper).insert((Object)orgLayout);
                }
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
    }
}

