import req from '@/request.js'

const bpmModel = window.context.bpmModel
const bpmRunTime = window.context.bpmRunTime
const portal = window.context.portal
export default {
  // 服务接口管理-树下拉接口
  treeAction() {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataApi/serviceCatalogs/v1/getTree`).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 新增服务接口目录
  addAPITree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/dataApi/serviceCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 编辑服务接口目录
  editAPITree(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/dataApi/serviceCatalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除服务接口目录
  removeAPITree(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/dataApi/serviceCatalogs/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 服务接口管理-新增接口
  addAction(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataApi/serviceApi/v1/register`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-编辑接口
  delAction(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataApi/serviceApi/v1/updateServiceApi`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 分页查询-列表
  treequeryTable(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/dataApi/serviceApi/v1/query`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-新增-数据源数据
  addSourceData() {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/datasourcesRelation/v1/queryList/3`).then(
        (response) => {
          resolve(response)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-按钮-接口文档查看
  interfaceData(id) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/dataApi/serviceApi/v1/viewApiDocument/${id}`).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-按钮-接口日志
  apiLog(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/log/serviceApiLog/v1/query`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // table列表-删除按钮接口
  delApiData(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/dataApi/serviceApi/v1/unregister?id=${id}`).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  // 服务接口管理-修改接口配置
  updateAction(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataApi/serviceApi/v1/updateServiceApi`, data).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  //发布接口
  // publishAPI(data) {
  //   return new Promise((resolve, reject) => {
  //     req.put(`${portal}/biz/dataApi/serviceApi/v1/publish`, data).then(
  //       (response) => {
  //         resolve(response.data)
  //       },
  //       (error) => {
  //         reject(error)
  //       }
  //     )
  //   })
  // },
  publishAPI(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataApi/serviceApi/v1/publish`, data, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded' // 确保后端能正确解析 FormData
        }
      }).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  },
  //下架接口
  // TakeoffAPI(data) {
  //   return new Promise((resolve, reject) => {
  //     req.put(`${portal}/biz/dataApi/serviceApi/v1/soldOut`, data).then(
  //       (response) => {
  //         resolve(response.data)
  //       },
  //       (error) => {
  //         reject(error)
  //       }
  //     )
  //   })
  // },
  TakeoffAPI(data) {
    return new Promise((resolve, reject) => {
      req.put(`${portal}/biz/dataApi/serviceApi/v1/soldOut`, data, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded' // 确保后端能正确解析 FormData
        }
      }).then(
        (response) => {
          resolve(response.data)
        },
        (error) => {
          reject(error)
        }
      )
    })
  }
}
