import req from '@/request.js'

const portal = window.context.portal

const headersUrlencoded = {
  Accept: 'application/json;charset=utf-8',
  'Content-type': 'multipart/form-data'
}
export default {
  // 移动表
  MoveData(queryParams, formData) {
    return new Promise((resolve, reject) => {
      // 拼接完整URL（查询参数）
      const url = `${portal}/biz/app/catalogs/table/v1/updateCatalog?${queryParams}`

      req.put(url, formData, {
        headers: {
          'Content-Type': 'application/x-www-form-urlencoded'
        }
      }).then(
        response => {
          if (response?.data?.state) {
            resolve(response.data)
          } else {
            reject(response?.data?.message || '操作失败')
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 获取APP资源目录下拉树
  getAPPTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/v1/getTree`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 新增APP资源目录
  addAPPTree(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 编辑APP资源目录
  editAPPTree(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/app/catalogs/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除APP资源目录
  removeAPPTree(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/app/catalogs/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 获取APP资源项
  queryAPPTable(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 新增APP资源项
  addAppSource(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 获取APP资源项
  editAppSource(data) {
    return new Promise((resolve, reject) => {
      req
        .put(`${portal}/biz/app/catalogs/table/v1/`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 删除APP资源项
  removeAppSource(id) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/removeTable?tableId=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 发布APP资源项
  publishAppSource(id) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/Deploy?tableId=${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 查询字段
  queryFieldsByTableId(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/field/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 保存字段
  saveFields(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/field/v1/saveOrUpdates`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 已发布表保存字段
  saveOrUpdateFields(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/field/v1/saveOrUpdateFields`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 字段删除
  deleteField(id) {
    return new Promise((resolve, reject) => {
      req
        .remove(`${portal}/biz/app/catalogs/table/field/v1/${id}`)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 物理表 数据查询
  queryWLTableData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/queryTableData`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 动态表 数据查询
  queryDTTableData(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/biz/app/catalogs/table/v1/queryDTTableData`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 数据治理日志
  dataGovernanceLog(data) {
    return new Promise((resolve, reject) => {
      req
        .post(`${portal}/bizAppData/cleanLogs/v1/query`, data)
        .then((res) => resolve(res.data || {}))
        .catch((err) => reject(err))
    })
  },

  // 数据上传模版下载
  downloadDataModel(tableId) {
    return new Promise((resolve, reject) => {
      req
        .downloadPostCopy(`${portal}/biz/app/catalogs/table/v1/downloadMainTempFile/${tableId}`)
        .then((res) => resolve(res?.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 建物理表语句
  physicalTable(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/app/catalogs/table/v1/queryTableSql/${tableId}`)
        .then((res) => resolve(res?.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 建动态表语句
  dynamicTable(tableId) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/app/catalogs/table/v1/queryDtTableSql/${tableId}`)
        .then((res) => resolve(res?.data || {}))
        .catch((err) => reject(err))
    })
  },
  // 验证
  checkSurfaceCh(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/app/catalogs/table/v1/checkPhysicsTableExists?tableNameEn=${data.tableNameEn}&type=${data.type}`).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 未有表发布
  unpublishedTable(data) {
    const param = {
      url: `${portal}/biz/app/catalogs/table/v1/deployDotHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  },
  // 已有表发布
  existingTablePublishing(data) {
    const param = {
      url: `${portal}/biz/app/catalogs/table/v1/deployHaveTable`,
      data,
      method: 'post',
      headers: headersUrlencoded
    }
    return new Promise((resolve, reject) => {
      req.request(param).then(
        response => {
          if (response.data?.state) {
            resolve(response.data)
          } else {
            reject(response)
          }
        },
        error => {
          reject(error)
        }
      )
    })
  }
}
