import req from '@/request.js';

const portal = window.context.portal;
export default {
  // 算法指标列表
  algorithmIndexList(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/catalogsIndex/v1/query`, data).then(
        response => {
          resolve(response.data);
        },
        error => {
          reject(error);
        }
      );
    });
  },

  // 查询特征指标编码是否存在
  saveAlgorithmCatalogsIndex(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/catalogsIndex/v1/saveAlgorithmCatalogsIndex`, data)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 删除指标
  deletePointer(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/algorithm/catalogsIndex/v1/${id}`)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 查询特征指标编码是否存在
  queryExistsByCode(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/catalogsIndex/v1/queryExistsByCode`, data)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 修改启用禁用状态
  updateFlagChange(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/catalogsIndex/v1/updateFlag`, data)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 根据id查询实体
  getDetailedData(id) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/biz/algorithm/catalogsIndex/v1/${id}`)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 根据key查询多维字典值
  getByDicKey(key) {
    return new Promise((resolve, reject) => {
      req.get(`${portal}/sys/dataDict/v1/getByDicKey?dicKey=${key}`)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 结果配置保存
  saveAlgorithmResultItemBatch(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/resultItem/v1/saveAlgorithmResultItemBatch`, data)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 结果配置 获取默认值
  resultItemChange(data) {
    return new Promise((resolve, reject) => {
      req.post(`${portal}/biz/algorithm/resultItem/v1/query`, data)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

  // 删除结果配置
  deleteResultItem(id) {
    return new Promise((resolve, reject) => {
      req.remove(`${portal}/biz/algorithm/resultItem/v1/${id}`)
        .then(
          resp => {
            resolve(resp.data);
          },
          error => {
            reject(error);
          }
        );
    });
  },

};
