package com.artfess.form.persistence.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.form.model.CustomQuery;
import com.artfess.form.vo.CustomQueryControllerVo;
import com.fasterxml.jackson.databind.node.ArrayNode;

import java.io.IOException;

public interface CustomQueryManager extends BaseManager<CustomQuery> {

    /**
     * 传入自定义查询参数，返回自定义查询结果。
     *
     * @param customQuery
     * @param queryData
     * @param dsType
     * @param page
     * @param pageSize
     * @return customQueryResult
     * @throws IOException
     */
    @SuppressWarnings("rawtypes")
    public PageList getData(CustomQuery customQuery, String queryData, String dsType, int page, int pageSize) throws IOException;

    /**
     * @param alias
     * @return Object
     * @throws
     * @since 1.0.0
     */
    public CustomQuery getByAlias(String alias);

    /**
     * 通过数据源名称查询库表或视图
     *
     * @param vo
     * @return
     * @throws Exception
     */
    public ArrayNode getTableOrViewByDsName(CustomQueryControllerVo vo) throws Exception;

    String export(String[] idList) throws Exception;

    void importFile(String unZipFilePath) throws Exception;
}
