package com.artfess.base.enums;

import com.artfess.base.util.StringUtil;
import lombok.Getter;

/**
 * 计算公式
 */
@Getter
public enum FaTargetTypeEnum {
    // 人事统计指标
    dysj(1,"当月实际VS预算分析","Analysis of actual VS budget CM","1,2"),
    ljsj(2,"累计实际VS预算分析","Analysis of actual VS budget YTD","3,4"),
    tbfx(3,"同比分析","Year-on-year analysis","3"),
    hbfx(4,"环比分析","Month-on-month analysis","1"),
    ndsj(5,"年度实际VS预算分析",":Annual actual VS budget analysis", "3,4"),
    scqysj(6,"生产企业实际VS预算分析","Actual VS budget analysis per plant", "3,4"),
    fscqysj(7,"非生产企业实际VS预算分析","Actual VS budget analysis per non-plant","3,4"),
    zzlfx(8,"年度增长率分析","Annual growth rate analysis", "5"),
    jtwclfx(9,"集团层面完成率分析","Completion rate analysis of Group level","6"),
    zqywclfx(10,"子企业完成率分析排名","Completion analysis ranking of subsidiaries", "6"),
    zbfx(11,"占比分析","Proportion analysis", "6"),
    zqydysj(12,"子企业当月实际VS集团均值排名","Actual of subsidiaries VS ranking of group average", "6"),
    ndsy(14,"年度实际VS预算分析","Annual actual VS budget analysis", "3,4"),
    jdlj(15,"年度实时余额分析","Annual real-time balance analysis", "9"),
    zqylj(16,"子企业累计实际情况分析","Actual YTD situation analysis of the subsidiaries", "3"),
    yhdk(17,"贷款明细","The details of loan", "3"),
    yhyk(18,"汇丰银行用款趋势","Used credit line of HSBC bank", "8,9"),
    oyll(19,"欧元同业拆借利率趋势图","Trend chart of Euro interbank offered interest rates", "11,12,13"),
    qt(20,"桥图","", ""),
    ;

    FaTargetTypeEnum(Integer type,String targetName, String targetNameEn,String staLat){
        this.type = type;
        this.targetName = targetName;
        this.targetNameEn = targetNameEn;
        this.staLat = staLat;
    }

    private String targetName;

    private String targetNameEn;

    private Integer type;


    private String staLat;


    public static FaTargetTypeEnum getTarget(String type){
        if(StringUtil.isEmpty(type)){
            return null;
        }
        FaTargetTypeEnum[] values = values();
        for (FaTargetTypeEnum state : values) {
            if (state.getType().equals(Integer.parseInt(type))) {
                return state;
            }
        }
        return null;
    }
}
