/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.trans;

import com.artfess.base.trans.other.Avgs;
import com.artfess.base.trans.other.Compute;
import com.artfess.base.trans.other.ReFilter;
import com.artfess.base.trans.other.Recurrence;
import com.artfess.base.trans.other.RepetitionSourceToTarget;
import com.artfess.base.trans.other.RepetitionToStr;
import com.artfess.base.trans.other.Trans;
import com.artfess.base.util.CollectionUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class TransitionUtil {
    public static <Tsource, Ttarget> Ttarget copy(Tsource tsource, Class<Ttarget> ttargetClass, Trans<Tsource, Ttarget> ... trans) {
        if (null == tsource) {
            return null;
        }
        Object target = null;
        try {
            target = ttargetClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BeanUtils.copyProperties(tsource, target);
        if (null != trans && trans.length > 0) {
            trans[0].copy(tsource, target);
        }
        return target;
    }

    public static <Tsource, Ttarget> List<Ttarget> copyList(List<Tsource> tsourceList, Class<Ttarget> ttargetClass, Trans<Tsource, Ttarget> ... trans) {
        ArrayList targetList = new ArrayList();
        if (CollectionUtils.isEmpty(tsourceList)) {
            return targetList;
        }
        if (null == ttargetClass) {
            return targetList;
        }
        for (Tsource source : tsourceList) {
            if (null == source) continue;
            Object target = null;
            try {
                target = ttargetClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            BeanUtils.copyProperties(source, target);
            if (CollectionUtils.isNotEmpty(trans)) {
                trans[0].copy(source, target);
            }
            targetList.add(target);
        }
        return targetList;
    }

    public static <Tsource, Ttarget> List<Ttarget> copyListThread(List<Tsource> tsourceList, Class<Ttarget> ttargetClass, Trans<Tsource, Ttarget> ... trans) {
        List targetList = Collections.synchronizedList(new ArrayList());
        if (CollectionUtils.isEmpty(tsourceList)) {
            return targetList;
        }
        tsourceList.parallelStream().forEach(source -> {
            if (null == source) {
                return;
            }
            Object target = null;
            try {
                target = ttargetClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            BeanUtils.copyProperties((Object)source, target);
            if (CollectionUtils.isNotEmpty(trans)) {
                trans[0].copy(source, target);
            }
            targetList.add(target);
        });
        return targetList;
    }

    public static <Tsource, Ttarget> Ttarget[] listToArray(List<Tsource> tsourceList, Class<? extends Ttarget[]> newType, RepetitionSourceToTarget<Tsource, Ttarget> ... repetition) {
        Object[] ttargets;
        Object[] objectArray = ttargets = newType == Object[].class ? new Object[tsourceList.size()] : (Object[])Array.newInstance(newType.getComponentType(), tsourceList.size());
        if (CollectionUtils.isEmpty(tsourceList)) {
            return ttargets;
        }
        for (int i = 0; i < tsourceList.size(); ++i) {
            Tsource source = tsourceList.get(i);
            if (!CollectionUtils.isNotEmpty(repetition)) continue;
            Ttarget target = repetition[0].deRepetition(source);
            ttargets[i] = target;
        }
        return ttargets;
    }

    public static <Tsource, Target> List<Tsource> deRepetition(Collection<Tsource> tsourceList, RepetitionSourceToTarget<Tsource, Target> ... repetitionToStrs) {
        if (CollectionUtils.isEmpty(tsourceList)) {
            return new ArrayList<Tsource>(tsourceList);
        }
        LinkedHashMap map = new LinkedHashMap();
        for (Tsource source : tsourceList) {
            if (null == source) continue;
            Object target = null;
            if (CollectionUtils.isNotEmpty(repetitionToStrs)) {
                target = repetitionToStrs[0].deRepetition(source);
            }
            if (map.containsKey(target)) continue;
            map.put(target, source);
        }
        ArrayList targetList = new ArrayList();
        Set keySet = map.keySet();
        for (Object target : keySet) {
            targetList.add(map.get(target));
        }
        return targetList;
    }

    public static <TKay, Tsource> Map<TKay, Tsource> listToMap(Collection<Tsource> tsourceList, RepetitionSourceToTarget<Tsource, TKay> repetitionSourceToTarget) {
        HashMap<TKay, Tsource> map = new HashMap<TKay, Tsource>();
        if (CollectionUtils.isEmpty(tsourceList)) {
            return map;
        }
        for (Tsource source : tsourceList) {
            if (null == source) continue;
            TKay key = repetitionSourceToTarget.deRepetition(source);
            map.put(key, source);
        }
        return map;
    }

    public static <Tsource, Target> int groupFiled(Collection<Tsource> tsourceList, RepetitionSourceToTarget<Tsource, Target> repetition) {
        if (CollectionUtils.isEmpty(tsourceList)) {
            return 0;
        }
        HashSet<Target> set = new HashSet<Target>();
        for (Tsource source : tsourceList) {
            if (null == source) continue;
            Target target = repetition.deRepetition(source);
            set.add(target);
        }
        return set.size();
    }

    public static <Tsource, Target> Map<Target, List<Tsource>> groupFiledMap(Collection<Tsource> tsourceList, RepetitionSourceToTarget<Tsource, Target> repetition) {
        HashMap<Target, ArrayList<Tsource>> map = new HashMap<Target, ArrayList<Tsource>>();
        if (CollectionUtils.isEmpty(tsourceList)) {
            return map;
        }
        for (Tsource source : tsourceList) {
            if (null == source) continue;
            Target target = repetition.deRepetition(source);
            ArrayList<Tsource> list = (ArrayList<Tsource>)map.get(target);
            if (null == list) {
                list = new ArrayList<Tsource>();
            }
            list.add(source);
            map.put(target, list);
        }
        return map;
    }

    public static <Tsource, Target> List<Target> arrayToList(Tsource[] tsources, RepetitionSourceToTarget<Tsource, Target> repetition) {
        ArrayList<Target> targetList = new ArrayList<Target>();
        if (CollectionUtils.isEmpty(tsources)) {
            return targetList;
        }
        for (Tsource source : tsources) {
            if (null == source) continue;
            Target target = repetition.deRepetition(source);
            targetList.add(target);
        }
        return targetList;
    }

    public static <Tsource, Target> List<Target> listFiledToList(Collection<Tsource> tsourceList, RepetitionSourceToTarget<Tsource, Target> repetition) {
        ArrayList<Target> targetList = new ArrayList<Target>();
        if (CollectionUtils.isEmpty(tsourceList)) {
            return targetList;
        }
        for (Tsource source : tsourceList) {
            targetList.add(repetition.deRepetition(source));
        }
        return targetList;
    }

    public static <Sum, Tsource> Sum sum(Collection<Tsource> tsourceList, Sum start, Compute<Sum, Tsource> compute) {
        if (CollectionUtils.isEmpty(tsourceList)) {
            return start;
        }
        for (Tsource source : tsourceList) {
            start = compute.compute(start, source);
        }
        return start;
    }

    public static <Tsource> String recurrenceUpToString(Tsource tsource, String split, Recurrence<Tsource> recurrence, RepetitionToStr<Tsource> repetitionToStr) {
        String tStr2;
        String upstr = "";
        if (null == tsource) {
            return upstr;
        }
        if (null == split) {
            split = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String tStr = repetitionToStr.deRepetition(tsource);
        if (null == tStr) {
            return upstr;
        }
        stringBuffer.append(tStr);
        Tsource tsource2 = recurrence.recurrence(tsource);
        if (null != tsource2 && StringUtils.isNotEmpty((CharSequence)(tStr2 = TransitionUtil.recurrenceUpToString(tsource2, split, recurrence, repetitionToStr)))) {
            stringBuffer.insert(0, split).insert(0, tStr2);
        }
        return stringBuffer.toString();
    }

    public static <Tsource> void average(List<Tsource> tsourceList, int oc, Avgs<Integer, Tsource> avgs) {
        if (CollectionUtils.isEmpty(tsourceList)) {
            return;
        }
        int[] avs = CollectionUtils.average(oc, tsourceList.size());
        for (int i = 0; i < tsourceList.size(); ++i) {
            Tsource tsource = tsourceList.get(i);
            avgs.setData(avs[i], tsource);
        }
    }

    public static <T> List<T> filter(List<T> tsourceList, ReFilter<T> reFilters) {
        ArrayList<T> targetList = new ArrayList<T>();
        if (CollectionUtils.isEmpty(tsourceList)) {
            return targetList;
        }
        for (T source : tsourceList) {
            boolean isok;
            if (null == source || !(isok = reFilters.filter(source))) continue;
            targetList.add(source);
        }
        return targetList;
    }

    public static <T> List<T> mapValueList(Map<String, T> map) {
        ArrayList<T> list = new ArrayList<T>();
        if (CollectionUtils.isEmpty(map)) {
            return list;
        }
        Set<String> keySet = map.keySet();
        for (String key : keySet) {
            list.add(map.get(key));
        }
        return list;
    }

    public static <T> List<T> listHashSet(List<T> data_list, Set<String> stringSet, RepetitionToStr<T> repetitionToStr, boolean has) {
        if (CollectionUtils.isEmpty(data_list) || null == repetitionToStr) {
            return new ArrayList();
        }
        if (CollectionUtils.isEmpty(stringSet)) {
            if (has) {
                return new ArrayList();
            }
            return data_list;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : data_list) {
            String ds = repetitionToStr.deRepetition(t);
            if (has) {
                if (!stringSet.contains(ds)) continue;
                list.add(t);
                continue;
            }
            if (stringSet.contains(ds)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T, E> List<T> newObject(List<T> oldList, List<T> newList, RepetitionSourceToTarget<T, E> repetitionSourceToTarget) {
        return TransitionUtil.newObject(oldList, newList, repetitionSourceToTarget, false);
    }

    public static <T, E> List<T> newObject(List<T> oldList, List<T> newList, RepetitionSourceToTarget<T, E> repetitionSourceToTarget, boolean in) {
        if (CollectionUtils.isEmpty(oldList)) {
            return newList;
        }
        if (CollectionUtils.isEmpty(newList)) {
            return newList;
        }
        HashMap<E, T> oldMap = new HashMap<E, T>();
        for (T t : oldList) {
            E e = repetitionSourceToTarget.deRepetition(t);
            oldMap.put(e, t);
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T t : newList) {
            E e = repetitionSourceToTarget.deRepetition(t);
            if (in != oldMap.containsKey(e)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T, E> T equalsObjFiled(T[] ts, E filed, RepetitionSourceToTarget<T, E> repetitionSourceToTarget) {
        if (CollectionUtils.isEmpty(ts) || null == filed || null == repetitionSourceToTarget) {
            return null;
        }
        for (T t : ts) {
            E e = repetitionSourceToTarget.deRepetition(t);
            if (!filed.equals(e)) continue;
            return t;
        }
        return null;
    }
}

