package com.artfess.file.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

/**
 * @Description: 系统附件存储配置
 * @Author: chens
 * @Date: 2021/6/8 9:48
 */
@TableName("PORTAL_SYS_FILE_STORAGE")
@ApiModel(value = "FileStorage", description = "系统附件存储配置")
public class FileStorage extends AutoFillModel<FileStorage> {

    private static final long serialVersionUID = 1L;
    @XmlTransient
    @TableId("ID_")
    @ApiModelProperty(value = "主键")
    protected String id;

    @XmlAttribute(name = "name")
    @TableField("NAME_")
    @ApiModelProperty(value = "名称")
    protected String name;

    @XmlAttribute(name = "code")
    @TableField("CODE_")
    @ApiModelProperty(value = "编码（唯一）")
    protected String code;

    @XmlAttribute(name = "uploadType")
    @TableField("UPLOAD_TYPE_")
    @ApiModelProperty(value = "上传方式：可用参数值：database（保存在数据库）；folder（保存在服务器文件目录）；ftp（上传到ftp；aliyunOss（保存在阿里云OSS）；minio；huaweiObs(上传附件到华为云)")
    protected String uploadType;

    @XmlAttribute(name = "location")
    @TableField("LOCATION_")
    @ApiModelProperty(value = "文件存储位置, 可能是磁盘路径, 或者是FTP存储根目录, 或者是阿里云OSS 主目录 BucketName,或者是minio的桶名 BucketName，或者华为云的桶名 BucketName")
    protected String location;

    @XmlAttribute(name = "url")
    @TableField("URL_")
    @ApiModelProperty(value = "ftp或者minio 上传地址")
    protected String url;

    @XmlAttribute(name = "port")
    @TableField("PORT_")
    @ApiModelProperty(value = "ftp或者minio 端口号")
    protected Integer port;

    @XmlAttribute(name = "userName")
    @TableField("USER_NAME_")
    @ApiModelProperty(value = "ftp或者minio 认证用户名")
    protected String userName;

    @XmlAttribute(name = "password")
    @TableField("PASSWORD_")
    @ApiModelProperty(value = "ftp或者minio 认证用户密码")
    protected String password;

    @XmlAttribute(name = "endpoint")
    @TableField("ENDPOINT_")
    @ApiModelProperty(value = "阿里云OSS、华为云obs 访问域名Endpoint ")
    protected String endpoint;

    @XmlAttribute(name = "accessKeyId")
    @TableField("ACCESSKEYID_")
    @ApiModelProperty(value = "阿里云OSS、华为云obs 访问密钥Id AccessKeyId")
    protected String accessKeyId;

    @XmlAttribute(name = "accessKeySecret")
    @TableField("ACCESSKEYSECRET_")
    @ApiModelProperty(value = "阿里云OSS、华为云obs 访问密钥Secret AccessKeySecret")
    protected String accessKeySecret;

    @XmlAttribute(name = "status")
    @TableField("STATUS_")
    @ApiModelProperty(value = "状态：enable(生效)，disable（无效）")
    protected String status;

    @XmlAttribute(name = "encryptName")
    @TableField("ENCRYPT_NAME_")
    @ApiModelProperty(value = "文件名是否加密（1：加密，0：不加密）")
    protected Integer encryptName;

    @XmlAttribute(name = "desc")
    @TableField("DESC_")
    @ApiModelProperty(value = "描述")
    protected String desc;

    @TableField("tenant_id_")
    @ApiModelProperty(name = "tenantId", notes = "租户id")
    protected String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getUploadType() {
        return uploadType;
    }

    public void setUploadType(String uploadType) {
        this.uploadType = uploadType;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getEncryptName() {
        return encryptName;
    }

    public void setEncryptName(Integer encryptName) {
        this.encryptName = encryptName;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("id", this.id)
                .append("name", this.name)
                .append("code", this.code)
                .append("uploadType", this.uploadType)
                .append("location", this.location)
                .append("url", this.url)
                .append("port", this.port)
                .append("userName", this.userName)
                .append("password", this.password)
                .append("tenantId", this.tenantId)
                .append("endpoint", this.endpoint)
                .append("accessKeyId", this.accessKeyId)
                .append("accessKeySecret", this.accessKeySecret)
                .append("status", this.status)
                .append("desc", this.desc)
                .toString();

    }
}