package com.artfess.base.util;


import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

/**
 * 集合的工具类
 *
 * @author Xing
 * @title:CollectionUtils
 * @form:Mr_xing
 * @date 2016年10月8日 上午11:41:56
 */
public class CollectionUtils {

    //长度>0返回true
    public static boolean isNotEmpty(Collection<?> collection) {
        return null != collection && collection.size() > 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return !isNotEmpty(collection);
    }


    //长度>0返回true
    public static boolean isNotEmpty(Map map) {
        return null != map && map.size() > 0;
    }

    public static boolean isEmpty(Map map) {
        return !isNotEmpty(map);
    }

    //数组
    public static <T> boolean isNotEmpty(T[] ts) {
        return null != ts && ts.length > 0;
    }

    public static <T> boolean isEmpty(T[] ts) {
        return !isNotEmpty(ts);
    }

    //从数组转化为集合
    public static <T> List<T> arrayToList(T[] ts) {
        List<T> list = new ArrayList();
        if (null != ts && ts.length > 0) {
            for (T t : ts) {
                list.add(t);
            }
        }
        return list;
    }

    /**
     * 随机返回几条数据，不重复
     *
     * @param list 数据源
     * @param row  随机返回几条
     * @return
     */
    public static <T> List<T> rand(List<T> list, int row) {
        // 如果不够随机
        if (isEmpty(list) || list.size() < row) {
            return list;
        }

        Set<T> nlist = new HashSet();
        Random random = new Random();
        // 仅仅取几条
        while (nlist.size() < row) {
            nlist.add(list.get(random.nextInt(list.size())));
        }
        return new ArrayList(nlist);
    }


    //计算长度，没有的为0
    public static int size(Collection collection) {
        if (isNotEmpty(collection)) {
            return collection.size();
        } else {
            return 0;
        }
    }

    //计算长度，没有为0
    public static int size(Map map) {
        if (isNotEmpty(map)) {
            return map.size();
        } else {
            return 0;
        }
    }

    //计算长度，没有的为0
    public static <T> int length(T[] ts) {
        if (isNotEmpty(ts)) {
            return ts.length;
        } else {
            return 0;
        }
    }

    /**
     * 把一个数字均分到集合上面去
     *
     * @param sum   总量
     * @param count 需要均分到多少
     * @return
     */
    public static int[] average(int sum, int count) {
        if (count < 1) {
            return new int[]{};
        }
        int[] ints = new int[count];

        int d1 = sum / count;
        int d2 = sum % count;

        //先初始化为0,加上每个都有的整数
        for (int i = 0; i < ints.length; i++) {
            ints[i] = 0 + d1;
        }

        //均分
        for (int i = 0; i < d2; i++) {
            ints[i] = ints[i] + 1;
        }

        return ints;
    }

    //根据下标得到数组内数据，可以避免空指针
    public static <T> T getIndex(List<T> list, int index) {
        if (CollectionUtils.isEmpty(list) || index < 0 || CollectionUtils.size(list) <= index - 1) {
            return null;
        }
        return list.get(index);
    }

    //根据下标得到数组内数据，可以避免空指针
    public static <T> T getIndex(T[] sources, int index) {
        if (CollectionUtils.isEmpty(sources) || index < 0 || CollectionUtils.length(sources) <= index - 1) {
            return null;
        }
        return sources[index];
    }

    //数组转化为set集合
    public static <T> Set<T> arrayToSet(T[] sources) {
        Set<T> set = new HashSet();
        if (CollectionUtils.isEmpty(sources)) {
            return set;
        }
        for (T t : sources) {
            set.add(t);
        }
        return set;
    }


    public static <T> boolean equalsRepeat(T[] sources) {
        return equalsRepeat(CollectionUtils.arrayToList(sources));
    }

    //判断是否有重复的数据,如果有，则为true，否则为false
    public static <T> boolean equalsRepeat(List<T> sourceList) {
        Set<T> set = new HashSet();
        for (T t : sourceList) {
            if (set.contains(t)) {
                return true;
            }
            set.add(t);
        }

        return false;
    }

    //初始化
    public static <T> List<T> init(List<T> list) {
        if (null == list) {
            return new ArrayList();
        } else {
            return list;
        }
    }

    //得到第一个
    public static <T> T getOne(Collection<T> collection) {
        if (CollectionUtils.isNotEmpty(collection)) {
            return collection.iterator().next();
        }
        return null;
    }

    /**
     * 将数据平均分到一个数组集合去
     *
     * @param thread 需要拆分多少组
     * @param list   拆分前的数据
     * @param <T>    拆分后的数组
     * @return
     */
    public static <T> ArrayList<T>[] averaging(int thread, List<T> list) {
        ArrayList[] zoneArrows = new ArrayList[thread];
        if (CollectionUtils.isEmpty(list)) {
            return zoneArrows;
        }
        // 不用计算每个需要多少，会有bug，直接简单粗暴，挨着填充
        for (int i = 0; i < list.size(); i++) {
            // 储存到数据第几个
            int in_size = (i % thread);
            ArrayList<T> li = zoneArrows[in_size];
            if (null == li) {
                li = new ArrayList();
            }
            li.add(list.get(i));
            zoneArrows[in_size] = li;

        }
        return zoneArrows;
    }


    public static void main(String[] args) {
        String[] ids = new String[]{"", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
        System.out.println(ids.length);

        int index = ids.length;
        for (int i = 1; i < ids.length; i++) {
            String[] ids2 = new String[i];
            for (int j = 0; j < i; j++) {
                ids2[j] = ids[j];
            }
            for (int k = 0; k < ids.length; k++) {
                String str = "i=" + i + "_k=" + k + ">";
                String str2 = null;
                try {
                    str2 = getIndex(ids2, k);
                } catch (Exception e) {
                }
                if (null == str2) {
                    str += "失败";
                } else {
                    str += "成功";
                }
                System.out.println(str);
            }
        }
    }

    public static JSONObject getHeaders(HttpServletRequest request) {
        //请求header，json
        JSONObject hearJson = new JSONObject();
        if (null == request) {
            return hearJson;
        }
        Map<String, String> map = Maps.newHashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            hearJson.put(key, request.getHeader(key));
            map.put(key, request.getHeader(key));
        }
        return hearJson;
    }


}
