package com.artfess.base.manager;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.service.IService;


/**
 * 基础服务层
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月9日
 */
public interface BaseManager<T extends Model<T>> extends IService<T>{
	/**
	 * 通过主键查询实体
	 * @param id
	 * @return
	 */
	T get(Serializable id);
	/**
	 * 添加实体
	 * @param t
	 */
	void create(T t);
	/**
	 * 更新实体
	 * @param t
	 */
	void update(T t);
	/**
	 * 通过主键删除实体
	 * @param id
	 */
	void remove(Serializable id);
	/**
	 * 通过主键集合批量删除实体
	 * @param ids
	 */
	void removeByIds(String ...ids);
	/**
	 * 通用查询
	 * @param queryFilter
	 * @return
	 */
	PageList<T> query(QueryFilter<T> queryFilter);
	/**
	 * 无分页通用查询
	 * @param queryFilter
	 * @return
	 */
	List<T> queryNoPage(QueryFilter<T> queryFilter);
	/**
	 * 无查询条件分页查询
	 * @param pageBean
	 * @return
	 */
	PageList<T> page(PageBean pageBean);
	/**
	 * 查询所有数据
	 * @return
	 */
	List<T> getAll();

	/**
	 * 根据ID_值修改排序号SN_
	 * @return
	 */
	void updateSequence(Map<String, Integer> params);

	/**
	 * 新增树
	 * @param entity
	 * @return 保存数据的ID
	 */
	String insertTree(BaseTreeModel entity);

	/**
	 * 新增树
	 * @param entity
	 * @return 保存数据的ID
	 */
	String saveTreeAndId(BaseTreeModel entity);

	/**
	 * 修改树
	 * @param entity
	 * @return 保存数据的ID
	 */
	String updateTree(BaseTreeModel entity,String oldName);

	/**
	 * @Description: 获取分组排序的下一排序号
	 * @param criteriaMap 分组条件<k,v> 其中k：字段名，v：是字段对映值
	 */
	Integer getNextSequence(Map<String,Object> criteriaMap);

	/**
	 * @Description: 根据父节点ID获取分组排序的下一排序号
	 * @param parentId 父节点ID
	 */
	Integer getNextSequenceByParentId(String parentId);

	/**
	 * 新增树
	 * @param entity
	 * @return 保存数据的ID
	 */
	String newInsertTree(CqltTreeModel entity);

	/**
	 * 修改树
	 * @param entity
	 * @return 保存数据的ID
	 */
	String newUpdateTree(CqltTreeModel entity,String oldName);

	/**
	 * 移动树的上下级
	 * @param entity
	 * @return
	 */
    boolean move(CqltTreeModel entity);
}
