package com.artfess.application.manager.impl;


import com.artfess.application.dao.SysMemberLogsDao;
import com.artfess.application.manager.SysMemberLogsManager;
import com.artfess.application.model.SysMemberLogs;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 
 * <pre> 
 * 描述：三员系统操作日志 处理实现类
 * </pre>
 */
@Service("sysMemberLogsManager")
public class SysMemberLogsManagerImpl extends BaseManagerImpl<SysMemberLogsDao, SysMemberLogs> implements SysMemberLogsManager {
	
	@Override
	public void removeByEexcutionTime(List<Map<String, Object>> params) {
		baseMapper.removeByEexcutionTime(params);
	}
	
	@Override
	public void create(SysMemberLogs log) {
		if(StringUtil.isNotEmpty(log.getOperate()) && log.getOperate().length()>480){
			log.setOperate(log.getOperate().substring(0, 480));
		}
		this.save(log);
	}
}
