package com.artfess.cqlt.vo;

import com.artfess.base.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 *
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Data
@ApiModel(value="ReportDataVo对象", description="运营--企业销售数据填报详情表")
public class ReportDataVo extends BaseModel<ReportDataVo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;


    @ApiModelProperty(value = "子企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "科目编码")
    private String subjectCode;

    @ApiModelProperty(value = "填报真实数据（真实的一个季度的数据）")
    private BigDecimal fillRealData;

    @ApiModelProperty(value = "填报虚数据（一个季度少一个月的数据）")
    private BigDecimal fillUnrealData;

    @ApiModelProperty(value = "去年填报真实数据（真实的一个季度的数据）")
    private BigDecimal lastYearfillRealData;

    @ApiModelProperty(value = "去年填报虚数据（一个季度少一个月的数据）")
    private BigDecimal lastYearfillUnrealData;




}
