package com.artfess.cqlt.vo;

import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 运营大屏统计请求参数vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="运营大屏统计请求参数vo")
public class OpReportRespVo {

    @ApiModelProperty(value = "预警值")
    private BigDecimal warnValue;

    @ApiModelProperty(value = "指标单位")
    private String targetUnit;

    @ApiModelProperty(value = "英文指标")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    private String targetName;

    @ApiModelProperty(value = "指标id")
    private String targetId;

    @ApiModelProperty(value = "数量")
    private Integer count;

    @ApiModelProperty(value = "统计展示纬度json数据")
    private JSONObject json;

    @ApiModelProperty(value = "年份")
    private Integer year;

    @ApiModelProperty(value = "季度")
    private Integer quarter;

    @ApiModelProperty(value = "月份")
    private Integer month;

    @ApiModelProperty(value = "周")
    private Integer week;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    private String enterpriseName;

    @ApiModelProperty(value = "洲别【字典】")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    private Integer enterpriseType;

    @ApiModelProperty(value = "实际值")
    private BigDecimal actual;

    @ApiModelProperty(value = "预算值")
    private BigDecimal budget;

    @ApiModelProperty(value = "差值")
    private BigDecimal differenceValue;

    @ApiModelProperty(value = "差值比率")
    private String differenceRate;

    @ApiModelProperty(value = "客户")
    private String customer;

    @ApiModelProperty(value = "产品")
    private String product;

    @ApiModelProperty(value = "类别")
    private String subjectName;

}
