package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.model.Tree;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 主题/专题分类表（sys_subject_class）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Data
@ApiModel(value="SysSubjectClass对象", description="主题/专题分类表（sys_subject_class）")
public class SysSubjectClass extends CqltTreeModel<SysSubjectClass> implements Tree {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "请选择所属业务", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属业务【字典】（财务：Finance,运营：operation,投资：invest,人力：hr,资金：money）")
    @TableField("business_")
    private String business;

    @NotBlank(message = "请选择指标级别", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "级别" ,column = "F")
    @ApiModelProperty(value = "级别")
    @TableField("level_")
    private String level;

    @Excel(name = "备注" ,column = "L")
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "指标密级程度（1：公开 2：内部 3：涉密）")
    @TableField(exist = false)
    private String classification;

    @Excel(name = "指标代码" ,column = "B")
    @ApiModelProperty(value = "指标代码（唯一值）")
    @TableField(exist = false)
    private String zbCode;

    @Excel(name = "指标名称" ,column = "C")
    @ApiModelProperty(value = "指标名称")
    @TableField(exist = false)
    private String zbName;

    @Excel(name = "上级指标编码" ,column = "D")
    @ApiModelProperty(value = "上级指标编码")
    @TableField(exist = false)
    private String parentCode;

    @NotBlank(message = "请填写指标计量单位", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "指标计量单位" ,column = "E")
    @ApiModelProperty(value = "指标计量单位（参考字典）")
    @TableField(exist = false)
    private String targetUnit;

    @ApiModelProperty(value = "指标描述&解释")
    @TableField(exist = false)
    private String targetMemo;

    @Excel(name = "统计纬度" ,column = "J")
    @ApiModelProperty(value = "统计纬度（1：统计值 2：实际值）")
    @TableField(exist = false)
    private String staLat;

    @Excel(name = "公式类型" ,column = "I")
    @ApiModelProperty(value = "公式类型（0：亚洲区域，1：欧洲区域，3：美洲区域，4：增长率）")
    @TableField(exist = false)
    private String analyseType;

    @ApiModelProperty(value = "是否可横向对比（0：否 1：是）")
    @TableField(exist = false)
    private String contrastHx;

    @ApiModelProperty(value = "是否可纵向对比（0：否 1：是）")
    @TableField(exist = false)
    private String contrastZx;

    @Excel(name = "大屏类型" ,column = "H")
    @ApiModelProperty(value = "大屏类型（1:集团数据，2：企业数据，3：区域数据）")
    @TableField(exist = false)
    private String largerType;

    @NotBlank(message = "请选择统计报表类型", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "报表类型" ,column = "G")
    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)(多选,隔开)")
    @TableField(exist = false)
    private String type;

    @Excel(name = "数据来源详细说明" ,column = "K")
    @ApiModelProperty(value = "数据来源详细说明")
    @TableField(exist = false)
    private String targetDataSourceMemo;

    @NotBlank(message = "请填写指标计算公式", groups = {AddGroup.class, UpdateGroup.class})
    @Excel(name = "指标计算公式" ,column = "M")
    @ApiModelProperty(value = "指标计算公式")
    @TableField(exist = false)
    private String targetCalculation;

    @Excel(name = "单位换算" ,column = "J")
    @ApiModelProperty(value = "单位换算(1:万欧 2：亿欧)")
    @TableField(exist = false)
    private String conversionUnit;

    @Excel(name = "链接主题" ,column = "O")
    @ApiModelProperty(value = "链接主题【字典】（财务：Finance,运营：operation,投资：invest,人力：hr,资金：money）")
    @TableField(exist = false)
    private String linksType;

    @Excel(name = "关联指标code" ,column = "N")
    @ApiModelProperty(value = "关联指标code")
    @TableField(exist = false)
    private String relatedCode;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<QfSubjectInternationalInfo> children = Lists.newArrayList();

    @Excel(name = "指标英文名称" ,column = "P")
    @ApiModelProperty(value = "指标英文名称")
    @TableField(exist = false)
    private String targetNameEn;

    @ApiModelProperty(value = "指标id")
    @TableField(exist = false)
    private String targetId;

    @ApiModelProperty(value = "指标名称")
    @TableField(exist = false)
    private String targetName;


    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }

}
