package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.CqltTreeModel;
import com.artfess.base.model.Tree;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.utils.FieldRepeat;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 国内准则科目信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-08
 */
@Data
@ApiModel(value="QfSubjectInfo对象", description="国内准则科目信息")
@FieldRepeat(fields = {"name","code"},message = "QfSubjectInfo.repeat",groups = {AddGroup.class, UpdateGroup.class})
public class QfSubjectInfo extends CqltTreeModel<QfSubjectInfo> implements Tree {

    private static final long serialVersionUID = 1L;

    @Excel(name = "科目类型" ,column = "A")
    @ApiModelProperty(value = "科目类型：科目所属的报表【字典】")
    @TableField("type_")
    private String type;

    @Excel(name = "科目英文名称" ,column = "C")
    @ApiModelProperty(value = "科目英文名称")
    @TableField("name_en_")
    private String nameEn;

    @Excel(name = "科目计量单位" ,column = "E")
    @ApiModelProperty(value = "科目计量单位")
    @TableField("unit_")
    private String unit;

    @Excel(name = "科目层级" ,column = "F")
    @ApiModelProperty(value = "级别【字典】（1：1级，2：二级，3：三级）")
    @TableField("level_")
    private Integer level;

    @Excel(name = "上级科目编码" ,column = "G")
    @ApiModelProperty(value = "上级_CODE")
    @TableField("parent_code_")
    protected String parentCode;

    @ApiModelProperty(value = "汇率类型（1：平均汇率，2：期末汇率）")
    @TableField("rate_type_")
    private Integer rateType;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "计算公式")
    @TableField("expression_")
    private String expression;

    @Excel(name = "科目名称" ,column = "B")
    @ApiModelProperty(value = "科目名称")
    @TableField(exist = false)
    private String subjectName;

    @Excel(name = "科目编码" ,column = "D")
    @ApiModelProperty(value = "科目编码")
    @TableField(exist = false)
    private String subjectCode;

    @TableField(exist = false)
    private Integer Snn;

    @Excel(name = "对应国际科目计算公式", column = "H")
    @TableField(exist = false)
    private String relation;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<QfSubjectInternationalInfo> children = Lists.newArrayList();

    @ApiModelProperty(value = "关联国际科目信息")
    @TableField(exist=false)
    private List<QfSubjectRelation> list;

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }
}
