package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 报表权限
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Data
@ApiModel(value="QfReportAuthority对象", description="报表权限")
public class QfReportAuthority extends BaseModel<QfReportAuthority> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报表id")
    @TableField("report_id_")
    @NotNull(message = "QfReportAuthority.reportId", groups = {AddGroup.class})
    private String reportId;

    @ApiModelProperty(value = "报表权限")
    @TableField("authority_")
    @NotNull(message = "QfReportAuthority.authority", groups = {AddGroup.class})
    private String authority;

    @ApiModelProperty(value = "授权对象类型")
    @TableField("object_type_")
    @NotNull(message = "QfReportAuthority.objectType", groups = {AddGroup.class})
    private String objectType;

    @ApiModelProperty(value = "授权对象id")
    @TableField("object_id_")
    @NotNull(message = "QfReportAuthority.objectId", groups = {AddGroup.class})
    private String objectId;

    @ApiModelProperty(value = "授权对象名称")
    @TableField(exist=false)
    private String name;




    @Override
    protected Serializable pkVal() {
        return this.id;
    }


}
