package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfReportAuthorityDao;
import com.artfess.cqlt.dao.QfReportInfoDao;
import com.artfess.cqlt.manager.QfReportAuthorityManager;
import com.artfess.cqlt.model.QfReportAuthority;
import com.artfess.cqlt.model.QfReportInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 报表权限 服务实现类
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-17
 */
@Service
public class QfReportAuthorityManagerImpl extends BaseManagerImpl<QfReportAuthorityDao, QfReportAuthority> implements QfReportAuthorityManager {

    @Resource
    private QfReportInfoDao reportInfoDao;

    @Override
    public CommonResult<PageList<QfReportAuthority>> selectList(Integer pageNum, Integer pageSize, String reportId) {
        PageBean pageBean = new PageBean();
        pageBean.setPage(pageNum);
        pageBean.setPageSize(pageSize);
        return new CommonResult<PageList<QfReportAuthority>>
                (true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()),
                        new PageList<QfReportAuthority>(baseMapper.selectByReportId(convert2IPage(pageBean), reportId)));
    }

    @Override
    public List<QfReportInfo> myAuthList(List<String> currentAndChildOrgIds, String currentUserId, Set<String> roleCodes, QfReportInfo t) {
        QueryWrapper<QfReportInfo> queryWrapper = new QueryWrapper<>();
        if (!StringUtil.isEmpty(t.getBusiness())) {
            queryWrapper.eq("business_", t.getBusiness());
        }
        if (null != t.getTyep()) {
            queryWrapper.eq("tyep_", t.getTyep());
        }
        if (!StringUtil.isEmpty(t.getName())) {
            queryWrapper.eq("name", t.getName());
        }
        List<QfReportInfo> allList = reportInfoDao.selectList(queryWrapper);

        List<String> roleIds = this.baseMapper.getRoleIds(roleCodes);
        List<QfReportInfo> qfReportInfos = this.baseMapper.myAuthList(currentAndChildOrgIds, currentUserId, roleIds, t);
        Map<String, QfReportInfo> reportInfoMap = qfReportInfos.stream().collect(Collectors.toMap(item -> item.getName(), item -> item));
        allList.forEach(qfReportInfo -> {
            QfReportInfo report = reportInfoMap.get(qfReportInfo.getName());
            if (null == report || StringUtil.isEmpty(report.getAuthority())) {
                qfReportInfo.setAuthority("qurey");
                return;
            }
            String authority = report.getAuthority();
            List<String> strings = Arrays.asList(authority.split(","));
            Long count = strings.stream().filter(x -> x.equals("qurey")).count();
            if (count < 1) {
                authority = authority + ",qurey";
            }
            qfReportInfo.setAuthority(authority);
        });

        return allList;
    }

}
