package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationMacrDDao;
import com.artfess.cqlt.dao.QfOperationMacrMDao;
import com.artfess.cqlt.dao.QfSubjectInternationalInfoDao;
import com.artfess.cqlt.manager.QfOperationMacrDManager;
import com.artfess.cqlt.model.QfOperationKpiM;
import com.artfess.cqlt.model.QfOperationMacrD;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 运营--宏观数据填报详情表   服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Service
public class QfOperationMacrDManagerImpl extends BaseManagerImpl<QfOperationMacrDDao, QfOperationMacrD> implements QfOperationMacrDManager {

    @Resource
    private QfOperationMacrMDao managerDao;

    @Resource
    private QfSubjectInternationalInfoDao subjectInternationalInfoDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfOperationMacrM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfOperationMacrM personM = managerDao.selectById(t.getId());
        Assert.notNull(personM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(personM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfSubjectInternationalInfo> query = new QueryWrapper<>();
        query.eq("IS_DELE_", DelStatusEnum.N.getType());
        List<QfSubjectInternationalInfo> qfSubjectInternationalInfos = subjectInternationalInfoDao.selectList(query);
        Map<String, QfSubjectInternationalInfo> detailMap = qfSubjectInternationalInfos.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        StringBuffer sb = new StringBuffer();
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(personM.getFillDate());
            if (StringUtils.isEmpty(detail.getSubjectCode())) {
                throw new BaseException(I18nUtil.getMessage("fill.code", LocaleContextHolder.getLocale()));
            }
            if (!detailMap.containsKey(detail.getSubjectCode())) {
                sb.append(",");
                sb.append(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = detailMap.get(detail.getSubjectCode());
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if(!StringUtils.isEmpty(subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }

        });
        if (sb.length() > 0) {
            throw new BaseException(sb.substring(1) + I18nUtil.getMessage("code.notExist", LocaleContextHolder.getLocale()));
        }
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

}
