package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLoanDDao;
import com.artfess.cqlt.dao.QfFinanceLoanMDao;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.model.QfFinanceLoanD;
import com.artfess.cqlt.model.QfFinanceLoanM;
import com.artfess.cqlt.vo.BankLoanDetailRespVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.MoneyReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 资金--贷款填报数据详情 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Service
public class QfFinanceLoanDManagerImpl extends BaseManagerImpl<QfFinanceLoanDDao, QfFinanceLoanD> implements QfFinanceLoanDManager {

    @Resource
    private QfFinanceLoanMDao loanMDao;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfFinanceLoanM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfFinanceLoanM QfFinanceLoanM = loanMDao.selectById(t.getId());
        Assert.notNull(QfFinanceLoanM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(QfFinanceLoanM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        List<QfFinanceLoanD> list = t.getList();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(QfFinanceLoanM.getFillDate());
        });
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<MoneyReportRespVo> cqltSgYearData(ReportReqVo t) {
        //获取当前指标的年季月趋势数据
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }

        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        return this.baseMapper.cqltSgYearData(t);
    }

    @Override
    public List<MoneyReportRespVo> cqltSgQuarterData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        return this.baseMapper.cqltSgQuarterData(t);
    }

    @Override
    public List<MoneyReportRespVo> sgYearData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }

        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        return this.baseMapper.sgYearData(t);
    }

    @Override
    public List<MoneyReportRespVo> sgQuarterData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        return this.baseMapper.sgQuarterData(t);
    }

    @Override
    public List<FaReportRespVo> nbwdYearAnalysis(ReportReqVo t) {
        return this.baseMapper.nbwdYearAnalysis(t);
    }

    @Override
    public List<FaReportRespVo> zzrzYearAnalysis(ReportReqVo t) {
        return this.baseMapper.zzrzYearAnalysis(t);
    }

    @Override
    public List<FaReportRespVo> dbzeQuarterCompanyAnalysis(ReportReqVo t) {
        return baseMapper.dbzeQuarterCompanyAnalysis(t);

    }

    @Override
    public List<FaReportRespVo> dkyeQuarterCompanyAnalysis(ReportReqVo t, String dataType) {
        return this.baseMapper.dkyeQuarterCompanyAnalysis(t, dataType);
    }

    @Override
    public List<BankLoanDetailRespVo> bankDetail(ReportReqVo t, String dataType) {
        return this.baseMapper.bankDetail(t,dataType);
    }

    @Override
    public BigDecimal getEarlyGuaranteeMoney(Integer year) {
        return baseMapper.getEarlyGuaranteeMoney(year);
    }

    @Override
    public List<FaReportRespVo> bankAnnualFigure(ReportReqVo t, String dataType) {
        return this.baseMapper.bankAnnualFigure(t,dataType);
    }

}
