package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfFinanceLoanD;
import com.artfess.cqlt.vo.BankLoanDetailRespVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.MoneyReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 资金--贷款填报数据详情 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinanceLoanDDao extends BaseMapper<QfFinanceLoanD> {

    List<MoneyReportRespVo> cqltSgYearData(@Param("vo") ReportReqVo t);

    List<MoneyReportRespVo> cqltSgQuarterData(@Param("vo") ReportReqVo t);

    List<MoneyReportRespVo> sgYearData(@Param("vo") ReportReqVo t);

    List<MoneyReportRespVo> sgQuarterData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> nbwdYearAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> zzrzYearAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> dbzeQuarterCompanyAnalysis(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> dkyeQuarterCompanyAnalysis(@Param("vo") ReportReqVo t, @Param("dataType") String dataType);

    List<BankLoanDetailRespVo> bankDetail(@Param("vo") ReportReqVo t, @Param("dataType") String dataType);

    BigDecimal getEarlyGuaranteeMoney(@Param("year") Integer year);

    List<FaReportRespVo> bankAnnualFigure(@Param("vo") ReportReqVo t, @Param("dataType") String dataType);
}
