package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfReportSubject;
import com.artfess.i18n.util.I18nUtil;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报表填报科目 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Api(tags = "报表科目")
@RestController
@RequestMapping("/qfReportSubject/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfReportSubjectController extends BaseController<QfReportSubjectManager, QfReportSubject> {
    @PostMapping("/insertInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) List<QfReportSubject> t) {
        t.forEach(qfReportSubject -> {
            qfReportSubject.setSn(baseService.getNextSequence(null));
        });
        if(!baseService.saveBatch(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/updateInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> updateInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) List<QfReportSubject> t) {
        t.forEach(qfReportSubject -> {
            qfReportSubject.setSn(baseService.getNextSequence(null));
        });
        if(!baseService.updateBatchById(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }



    @GetMapping("deleteById/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        if(!baseService.removeById(id)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @GetMapping("deleteByIds")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/getList")
    @ApiOperation("科目项目分页查询")
    public CommonResult<PageList<QfReportSubject>> getList(@RequestBody QueryFilter<QfReportSubject> queryFilter) {
        List<FieldSort> sorter = queryFilter.getSorter();
        sorter.add(new FieldSort("sn_", Direction.ASC));
        queryFilter.setSorter(sorter);
        return new CommonResult<PageList<QfReportSubject>>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), super.query(queryFilter));
    }

}
