package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.model.QfReportRange;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.model.QfReportRange;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 报表填报范围 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Api(tags = "报表企业范围")
@RestController
@RequestMapping("/qfReportRange/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfReportRangeController extends BaseController<QfReportRangeManager, QfReportRange> {

    @PostMapping("/insertInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) List<QfReportRange> t) {
        if(!baseService.saveBatch(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/updateInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> updateInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) List<QfReportRange> t) {
        if(!baseService.updateBatchById(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }



    @GetMapping("deleteById/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        if(!baseService.removeById(id)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @GetMapping("deleteByIds")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @GetMapping("/getList")
    @ApiOperation("根据reportId查询企业范围")
    public CommonResult<PageList<QfReportRange>> getList(@RequestParam (required = true)Integer pageNum,@RequestParam (required = true)Integer pageSize,@RequestParam (required = true)String reportId) {
       return baseService.selectList(pageNum,pageSize,reportId);
    }

}
