package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.QfReportInfoManager;
import com.artfess.cqlt.model.QfOperationKpiM;
import com.artfess.cqlt.model.QfReportInfo;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 报表信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Api(tags = "报表管理")
@RestController
@RequestMapping("/qfReportInfo/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfReportInfoController extends BaseController<QfReportInfoManager, QfReportInfo> {

    @PostMapping("/insertInfo")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> insertInfo(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) QfReportInfo t) {
        if(!baseService.save(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @PostMapping("/updateInfoById")
    @ApiOperation("更新实体")
    public CommonResult<String> updateInfoById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) QfReportInfo t) {
        if(!baseService.updateById(t)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("update.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @GetMapping("deleteById/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="实体id") @PathVariable String id) {
        if(!baseService.removeById(id)) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/getList")
    @ApiOperation("企业分页查询")
    public CommonResult<PageList<QfReportInfo>> getList(@RequestBody QueryFilter<QfReportInfo> queryFilter) {
        return new CommonResult<PageList<QfReportInfo>>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), super.query(queryFilter));
    }

    @PutMapping("/updateStatus")
    @ApiOperation("发布")
    public CommonResult<String> updateStatus(@ApiParam(name = "model", value = "实体信息") @RequestBody QfReportInfo t) {
        boolean result = baseService.updateStatus(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }




}
