package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cqlt.model.QfOperationMacrD;
import com.artfess.cqlt.manager.QfOperationMacrDManager;

import java.util.Arrays;

/**
 * 运营--宏观数据填报详情表   前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Slf4j
@RestController
@Api(tags = "运营--宏观数据填报详情表")
@RequestMapping("/qf/operation/macr/detail/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfOperationMacrDController extends BaseController<QfOperationMacrDManager, QfOperationMacrD> {

    @PostMapping("/batchUpdate")
    @ApiOperation("批量保存实体的接口")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody QfOperationMacrM t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }

        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询结果")
    public PageList<QfOperationMacrD> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<QfOperationMacrD> queryFilter) {
        return baseService.query(queryFilter);
    }
}
