package com.artfess.cqlt.controller;


import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfInvestPatentDManager;
import com.artfess.cqlt.model.QfInvestPatentD;
import com.artfess.cqlt.model.QfInvestPatentM;
import com.artfess.cqlt.model.QfInvestProductivityD;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 投资--萨固密集团专利授权数据填报详情表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-23
 */
@Slf4j
@RestController
@Api(tags = "投资--萨固密集团专利授权详情数据")
@RequestMapping("/qf/invest/parent/detail")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfInvestPatentDController extends BaseController<QfInvestPatentDManager, QfInvestPatentD> {

    @PostMapping("/batchSave")
    @ApiOperation("批量添加实体的接口")
    public CommonResult<String> batchSave(@ApiParam(name = "model", value = "实体信息") @RequestBody QfInvestPatentM t) {
        boolean result = baseService.batchSave(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }

        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PutMapping("/batchUpdate")
    @ApiOperation("批量更新实体")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody QfInvestPatentM t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }



    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping("/investmentSituation")
    @ApiOperation(value = "投资看板--投资情况", notes = "年度投资，包括专利授权情况")
    public CommonResult<String> investmentSituation(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        JSONObject data = baseService.investmentSituation(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/capacitySituation")
    @ApiOperation(value = "投资看板--产能情况")
    public CommonResult<String> capacitySituation(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<QfInvestProductivityD> data = baseService.capacitySituation(t);
        return CommonResult.success(data, null);
    }

}
