package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.cqlt.vo.ReportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 财务主题大屏统计宽表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Slf4j
@RestController
@Api(tags = "大屏统计--财务主题")
@RequestMapping("/qf/finance/statistical/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfFinancialStatisticalController extends BaseController<QfFinancialStatisticalManager, QfFinancialStatistical> {

    @PostMapping("/oneLevelData")
    @ApiOperation(value = "财务大屏一级指标统计接口", response = FaTargetRespVo.class)
    public CommonResult<String> oneLevelData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.data(t);
        return CommonResult.success(data, null);
    }
    @PostMapping("/fromUnderData")
    @ApiOperation("财务大屏当前以及下撰指标统计接口")
    public CommonResult<String> fromUnderData(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.fromUnderData(t);
        return CommonResult.success(data, null);
    }


    @PostMapping("/dataAnalysis")
    @ApiOperation("数据分析接口")
    public CommonResult<String> dataAnalysis(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.dataAnalysis(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/bridgeFigureAnalysis")
    @ApiOperation("桥图")
    public CommonResult<String> bridgeFigureAnalysis(@ApiParam(name = "model", value = "请求参数") @RequestBody ReportReqVo t) {
        List<FaTargetRespVo> data = baseService.bridgeFigureAnalysis(t);
        return CommonResult.success(data, null);
    }

}
