package com.artfess.cqlt.controller;


import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfFinanceBsBudgetMManager;
import com.artfess.cqlt.manager.QfFinanceBsMManager;
import com.artfess.cqlt.manager.QfFinanceCfBudgetMManager;
import com.artfess.cqlt.manager.QfFinanceCfMManager;
import com.artfess.cqlt.manager.QfFinancePlBudgetMManager;
import com.artfess.cqlt.manager.QfFinancePlMManager;
import com.artfess.cqlt.model.QfFinanceBsBudgetM;
import com.artfess.cqlt.model.QfFinanceBsM;
import com.artfess.cqlt.model.QfFinanceCfBudgetM;
import com.artfess.cqlt.model.QfFinanceCfM;
import com.artfess.cqlt.model.QfFinancePlBudgetM;
import com.artfess.cqlt.model.QfFinancePlM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cqlt.model.QfFinanceBsS;
import com.artfess.cqlt.manager.QfFinanceBsSManager;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;
import java.util.Map;

/**
 * 财务-资产负债汇总表 前端控制器
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-02
 */
@Slf4j
@RestController
@Api(tags = "大屏数据-导入")
@RequestMapping("/qf/import/data/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfFinanceBsSController extends BaseController<QfFinanceBsSManager, QfFinanceBsS> {


    @Autowired
    private QfFinanceCfBudgetMManager cfBudgetMManager;

    @Autowired
    private QfFinanceCfMManager cfMManager;

    @Autowired
    private QfFinancePlBudgetMManager plBudgetMManager;

    @Autowired
    private QfFinancePlMManager plMManager;

    @Autowired
    private QfFinanceBsBudgetMManager bsBudgetMManager;

    @Autowired
    private QfFinanceBsMManager bsMManager;


    /**
     * @param fileList
     * @return
     */
    @ApiOperation(value = "实际数据按年导入")
    @PostMapping("/importActualExcel")
    public CommonResult<String> importExcel(@RequestParam("file") List<MultipartFile> fileList) {

        try {
            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }
                if (file.getOriginalFilename().contains("PL")) {
                    QueryWrapper<QfFinancePlM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = plMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    plMManager.importExcel(list, mainId);
                    try {
                        Thread.sleep(3 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });

            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }
                if (file.getOriginalFilename().contains("BS")) {
                    QueryWrapper<QfFinanceBsM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = bsMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    bsMManager.importExcel(list, mainId);
                    try {
                        Thread.sleep(3 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });

            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }
                if (file.getOriginalFilename().contains("CF")) {
                    QueryWrapper<QfFinanceCfM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = cfMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    cfMManager.importExcel(list, mainId);
                }
            });
            return new CommonResult<>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage("import.fail", LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }

    }

    /**
     * @param fileList
     * @return
     */
    @ApiOperation(value = "预算数据按年导入")
    @PostMapping("/importBudgetExcel")
    public CommonResult<String> importBudgetExcel(@RequestParam("file") List<MultipartFile> fileList) {


        try {
            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }
                if (file.getOriginalFilename().contains("PL")) {
                    QueryWrapper<QfFinancePlBudgetM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = plBudgetMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    plBudgetMManager.importExcel(list, mainId);
                    try {
                        Thread.sleep(3 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }
                if (file.getOriginalFilename().contains("BS")) {
                    QueryWrapper<QfFinanceBsBudgetM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = bsBudgetMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    bsBudgetMManager.importExcel(list, mainId);
                    try {
                        Thread.sleep(3 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }

            });
            fileList.forEach(file -> {
                String year = file.getOriginalFilename().substring(0, 4);
                String month = file.getOriginalFilename().substring(4, 6);
                if (month.startsWith("0")) {
                    month = month.substring(1);
                }

                if (file.getOriginalFilename().contains("CF")) {
                    QueryWrapper<QfFinanceCfBudgetM> queryWrapper = new QueryWrapper<>();
                    queryWrapper.eq("fill_year_", year);
                    queryWrapper.eq("fill_month_", month);
                    String mainId = cfBudgetMManager.getOne(queryWrapper).getId();
                    List<HeaderNode> list = ExcelUtil.importAllData(file, false);
                    cfBudgetMManager.importExcel(list, mainId);
                }
            });
            return new CommonResult<>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage("import.fail", LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }

    }

}
