/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfFinanceBsBudgetDDao;
import com.artfess.cqlt.dao.QfFinanceBsBudgetMDao;
import com.artfess.cqlt.manager.QfFinanceBsBudgetDManager;
import com.artfess.cqlt.manager.QfFinanceBsBudgetSManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceBsBudgetD;
import com.artfess.cqlt.model.QfFinanceBsBudgetM;
import com.artfess.cqlt.model.QfFinanceBsBudgetS;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceBsBudgetDManagerImpl
extends BaseManagerImpl<QfFinanceBsBudgetDDao, QfFinanceBsBudgetD>
implements QfFinanceBsBudgetDManager {
    @Resource
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;
    @Resource
    private QfFinanceBsBudgetMDao mainDao;
    @Autowired
    private QfFinanceBsBudgetSManager sumManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinanceBsBudgetM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinanceBsBudgetM budgetM = (QfFinanceBsBudgetM)((Object)this.mainDao.selectById((Serializable)((Object)t.getId())));
        ArrayList list = Lists.newArrayList();
        ArrayList totalList = Lists.newArrayList();
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("PL");
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(budgetM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfFinanceBsBudgetD QfFinanceBsBudgetD2 = (QfFinanceBsBudgetD)((Object)((Object)((QfFinanceBsBudgetDDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != QfFinanceBsBudgetD2) {
                QfFinanceBsBudgetD2.setBudgetYtd(detail.getBudgetYtd());
                list.add(QfFinanceBsBudgetD2);
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                list.add(detail);
            }
        });
        t.getTotalList().forEach(detail -> {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"subject_code_", (Object)detail.getSubjectCode());
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            QfFinanceBsBudgetS financePlBudgetS = (QfFinanceBsBudgetS)((Object)((Object)this.sumManager.getBaseMapper().selectOne((Wrapper)queryWrapper)));
            if (null != financePlBudgetS) {
                if (null != detail.getBudgetTotal()) {
                    financePlBudgetS.setBudgetTotal(detail.getBudgetTotal());
                }
                if (null != detail.getBudgetPosting()) {
                    financePlBudgetS.setBudgetPosting(detail.getBudgetPosting());
                }
                if (null != detail.getBudgetConsolidated()) {
                    financePlBudgetS.setBudgetConsolidated(detail.getBudgetConsolidated());
                }
                totalList.add(financePlBudgetS);
            } else {
                detail.setFillDate(budgetM.getFillDate());
                detail.setFillQuarter(budgetM.getFillQuarter());
                detail.setFillMonth(budgetM.getFillMonth());
                detail.setFillYear(budgetM.getFillYear());
                detail.setMainId(t.getId());
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                totalList.add(detail);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.saveOrUpdateBatch(list);
        }
        if (!CollectionUtils.isEmpty((Collection)totalList)) {
            this.sumManager.saveOrUpdateBatch(totalList);
        }
        return true;
    }

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceBsBudgetD> list, String sheetName) throws IOException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        List financePlSList = this.sumManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<String> enterpriseCodeHeader = ((QfFinanceBsBudgetDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfFinanceBsBudgetDDao)this.baseMapper).getSubjectCodes(mainId);
        HashMap rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<Integer>(0);
        subjectCodes.forEach(subjectCode -> {
            row.getAndSet((Integer)row.get() + 1);
            rowMap.put(subjectCode, row.get());
        });
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        AtomicReference<Integer> column = new AtomicReference<Integer>(1);
        enterpriseCodeHeader.forEach(code -> {
            column.getAndSet((Integer)column.get() + 1);
            HeaderNode headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(((Integer)column.get()).intValue());
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            columMap.put(code, headerNode.getColumn());
        });
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(0);
        headerNode.setHeaderName("subjectName");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(1);
        headerNode.setHeaderName("subjectCode");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 1);
        headerNode.setHeaderName("Total");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 2);
        headerNode.setHeaderName("Consolidation Posting");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(columMap.size() + 3);
        headerNode.setHeaderName("Consolidated Financial Statement");
        headerNodeList.add(headerNode);
        list.forEach(detail -> {
            HeaderNode node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(((Integer)columMap.get(detail.getEnterpriseCode())).intValue());
            node.setHeaderName(detail.getBudgetYtd().toString());
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(0);
            String spaceStr = StringUtil.addSpace((Integer)detail.getSubjectLevel());
            node.setHeaderName(spaceStr + detail.getSubjectName());
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getSubjectCode())).intValue());
            node.setColumn(1);
            node.setHeaderName(detail.getSubjectCode());
            headerNodeList.add(node);
        });
        Integer maxColum = columMap.size();
        financePlSList.forEach(pls -> {
            HeaderNode node = new HeaderNode();
            if (null != pls.getBudgetConsolidated()) {
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 3);
                node.setHeaderName(pls.getBudgetConsolidated() + "");
                headerNodeList.add(node);
            }
            if (null != pls.getBudgetPosting()) {
                node = new HeaderNode();
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 2);
                node.setHeaderName(pls.getBudgetPosting() + "");
                headerNodeList.add(node);
            }
            if (null != pls.getBudgetTotal()) {
                node = new HeaderNode();
                node.setRow(((Integer)rowMap.get(pls.getSubjectCode())).intValue());
                node.setColumn(maxColum + 1);
                node.setHeaderName(pls.getBudgetTotal() + "");
                headerNodeList.add(node);
            }
        });
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }

    @Override
    public List<JSONObject> detailQuery(List<QfFinanceBsBudgetD> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        List financePlSList = this.sumManager.getBaseMapper().selectList((Wrapper)queryWrapper);
        List<String> enterpriseCodeHeader = ((QfFinanceBsBudgetDDao)this.baseMapper).getEnterpriseCodeHeader(mainId);
        List<String> subjectCodes = ((QfFinanceBsBudgetDDao)this.baseMapper).getSubjectCodes(mainId);
        ArrayList detailList = Lists.newArrayList();
        JSONObject detail = new JSONObject(true);
        detail.put("subjectName", (Object)"subjectName");
        detail.put("subjectCode", (Object)"subjectCode");
        detail.put("subjectUnit", (Object)"subjectUnit");
        detail.put("subjectLevel", (Object)"subjectLevel");
        enterpriseCodeHeader.forEach(code -> detail.put(code, code));
        detail.put("Total", (Object)"Total");
        detail.put("Consolidation Posting", (Object)"Consolidation Posting");
        detail.put("Consolidated Financial Statement", (Object)"Consolidated Financial Statement");
        detailList.add(detail);
        for (String subjectCode : subjectCodes) {
            JSONObject data = new JSONObject(true);
            data.put("subjectCode", (Object)subjectCode);
            for (QfFinanceBsBudgetD pld : list) {
                if (!pld.getSubjectCode().equals(subjectCode)) continue;
                data.put("subjectName", (Object)pld.getSubjectName());
                data.put("subjectUnit", (Object)pld.getSubjectUnit());
                data.put("subjectLevel", (Object)pld.getSubjectLevel());
                data.put(pld.getEnterpriseCode(), (Object)pld.getBudgetYtd());
            }
            for (QfFinanceBsBudgetS pls : financePlSList) {
                if (!pls.getSubjectCode().equals(subjectCode)) continue;
                data.put("Total", (Object)pls.getBudgetTotal());
                data.put("Consolidation Posting", (Object)pls.getBudgetPosting());
                data.put("Consolidated Financial Statement", (Object)pls.getBudgetConsolidated());
            }
            detailList.add(data);
        }
        return detailList;
    }
}

