/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationKpiMDao;
import com.artfess.cqlt.manager.QfOperationKpiDManager;
import com.artfess.cqlt.manager.QfOperationKpiMManager;
import com.artfess.cqlt.model.QfOperationKpiD;
import com.artfess.cqlt.model.QfOperationKpiM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfOperationKpiMManagerImpl
extends BaseManagerImpl<QfOperationKpiMDao, QfOperationKpiM>
implements QfOperationKpiMManager {
    private static final Logger log = LoggerFactory.getLogger(QfOperationKpiMManagerImpl.class);
    @Autowired
    private QfOperationKpiDManager operationKpiDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationKpiD> list, String mainId) {
        QfOperationKpiM qfOperationKpiM = (QfOperationKpiM)((Object)((QfOperationKpiMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)qfOperationKpiM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationKpiDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(qfOperationKpiM.getFillDate());
        });
        boolean b = this.operationKpiDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationKpiM t) {
        QfOperationKpiM qfOperationKpiM = (QfOperationKpiM)((Object)((QfOperationKpiMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationKpiMDao)this.baseMapper).updateById((Object)qfOperationKpiM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationKpiM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List qfOperationKpiMS = ((QfOperationKpiMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationKpiMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationKpiM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List qfOperationKpiMS = ((QfOperationKpiMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationKpiMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

