/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.dao.QfFinanceLiquidityDetailDao;
import com.artfess.cqlt.dao.QfFinanceLiquidityMDao;
import com.artfess.cqlt.manager.QfFinanceLiquidityDetailManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceLiquidityDetail;
import com.artfess.cqlt.model.QfFinanceLiquidityM;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfFinanceLiquidityDetailManagerImpl
extends BaseManagerImpl<QfFinanceLiquidityDetailDao, QfFinanceLiquidityDetail>
implements QfFinanceLiquidityDetailManager {
    private static final String SGGR_SLR = "SGGR_SLR";
    private static final String SLR = "SLR";
    @Resource
    private QfEnterpriseInfoDao enterpriseInfoDao;
    @Resource
    private QfFinanceLiquidityMDao financeLiquidityMDao;

    @Override
    public List<JSONObject> detailQuery(List<QfFinanceLiquidityDetail> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        String mainId = list.get(0).getMainId();
        QfFinanceLiquidityM mainInfo = (QfFinanceLiquidityM)((Object)this.financeLiquidityMDao.selectById((Serializable)((Object)mainId)));
        if (null == mainInfo) {
            return Lists.newArrayList();
        }
        List<Integer> header = ((QfFinanceLiquidityDetailDao)this.baseMapper).getHeader(mainId);
        List<String> enterpriseCodes = ((QfFinanceLiquidityDetailDao)this.baseMapper).getEnterpriseCode(mainId);
        ArrayList detailList = Lists.newArrayList();
        HashMap columMap = Maps.newHashMap();
        JSONObject detail = new JSONObject(true);
        detail.put("Period", (Object)"Period");
        LocalDate localDate = LocalDate.of((int)mainInfo.getFillYear(), 1, 1);
        header.forEach(week -> {
            if (week.equals(mainInfo.getFillWeek())) {
                detail.put("Liquidity Starting\nBalance", (Object)"Liquidity Starting\nBalance");
                columMap.put(week, "Liquidity Starting\nBalance");
            } else {
                LocalDate startTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week - 1, DayOfWeek.SATURDAY));
                LocalDate endTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week, DayOfWeek.FRIDAY));
                detail.put(startTime + "\n-" + endTime, (Object)(startTime + "\n-" + endTime));
                columMap.put(week, startTime + "\n-" + endTime);
            }
        });
        detailList.add(detail);
        for (String code : enterpriseCodes) {
            JSONObject data = new JSONObject(true);
            if (!SLR.equals(code) && !SGGR_SLR.equals(code)) {
                data.put("Period", (Object)code);
            } else {
                data.put("Period", null);
                data.put((String)columMap.get(mainInfo.getFillWeek()), (Object)code);
            }
            for (QfFinanceLiquidityDetail liquidityDetail : list) {
                if (!liquidityDetail.getEnterpriseCode().equals(code) || !columMap.containsKey(liquidityDetail.getFillWeek())) continue;
                data.put((String)columMap.get(liquidityDetail.getFillWeek()), (Object)liquidityDetail.getFillData());
            }
            detailList.add(data);
        }
        return detailList;
    }

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceLiquidityDetail> list, String sheetName) throws IOException {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();
        QfFinanceLiquidityM mainInfo = (QfFinanceLiquidityM)((Object)this.financeLiquidityMDao.selectById((Serializable)((Object)mainId)));
        if (null == mainInfo) {
            return;
        }
        List<Integer> header = ((QfFinanceLiquidityDetailDao)this.baseMapper).getHeader(mainId);
        List<String> enterpriseCodes = ((QfFinanceLiquidityDetailDao)this.baseMapper).getEnterpriseCode(mainId);
        HashMap rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<Integer>(0);
        enterpriseCodes.forEach(enterpriseCode -> {
            row.getAndSet((Integer)row.get() + 1);
            rowMap.put(enterpriseCode, row.get());
        });
        LocalDate localDate = LocalDate.of((int)mainInfo.getFillYear(), 1, 1);
        HashMap columMap = Maps.newHashMap();
        ArrayList headerNodeList = Lists.newArrayList();
        AtomicReference<Integer> column = new AtomicReference<Integer>(0);
        header.forEach(week -> {
            column.getAndSet((Integer)column.get() + 1);
            HeaderNode headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(((Integer)column.get()).intValue());
            if (1 == (Integer)column.get()) {
                headerNode.setHeaderName("Liquidity Starting\nBalance");
            } else {
                LocalDate startTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week - 1, DayOfWeek.SATURDAY));
                LocalDate endTime = localDate.with(TemporalAdjusters.dayOfWeekInMonth(week, DayOfWeek.FRIDAY));
                headerNode.setHeaderName(startTime + "\n-" + endTime);
            }
            headerNodeList.add(headerNode);
            columMap.put(week + "", headerNode.getColumn());
        });
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(0);
        headerNode.setColumn(0);
        headerNode.setHeaderName("Period");
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(((Integer)rowMap.get(SLR)).intValue());
        headerNode.setColumn(1);
        headerNode.setHeaderName(SLR);
        headerNodeList.add(headerNode);
        headerNode = new HeaderNode();
        headerNode.setRow(((Integer)rowMap.get(SGGR_SLR)).intValue());
        headerNode.setColumn(1);
        headerNode.setHeaderName(SGGR_SLR);
        headerNodeList.add(headerNode);
        list.forEach(detail -> {
            HeaderNode node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getEnterpriseCode())).intValue());
            node.setColumn(((Integer)columMap.get(detail.getFillWeek() + "")).intValue());
            if (null != detail.getFillData()) {
                node.setHeaderName(detail.getFillData() + "");
            }
            headerNodeList.add(node);
            node = new HeaderNode();
            node.setRow(((Integer)rowMap.get(detail.getEnterpriseCode())).intValue());
            node.setColumn(0);
            if (!SLR.equals(detail.getEnterpriseCode()) && !SGGR_SLR.equals(detail.getEnterpriseCode())) {
                node.setHeaderName(detail.getEnterpriseCode());
            }
            headerNodeList.add(node);
        });
        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export((List)headerNodeList, (HttpServletResponse)response, (String)fileName, (String)sheetName);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean batchUpdate(QfFinanceLiquidityM t) {
        Assert.hasText((String)t.getId(), (String)I18nUtil.getMessage((String)"QfOperationKpiM.reportId", (Locale)LocaleContextHolder.getLocale()));
        QfFinanceLiquidityM liquidityM = (QfFinanceLiquidityM)((Object)this.financeLiquidityMDao.selectById((Serializable)((Object)t.getId())));
        ArrayList list = Lists.newArrayList();
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = this.enterpriseInfoDao.selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        t.getList().forEach(detail -> {
            detail.setFillDate(liquidityM.getFillDate());
            detail.setMainId(t.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"main_id_", (Object)t.getId());
            queryWrapper.eq((Object)"enterprise_code_", (Object)detail.getEnterpriseCode());
            QfFinanceLiquidityDetail liquidityDetail = (QfFinanceLiquidityDetail)((Object)((Object)((QfFinanceLiquidityDetailDao)this.baseMapper).selectOne((Wrapper)queryWrapper)));
            if (null != liquidityDetail) {
                liquidityDetail.setFillData(detail.getFillData());
                list.add(liquidityDetail);
            } else {
                if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(detail.getEnterpriseCode())));
                    detail.setEnterpriseName(qfEnterpriseInfo.getName());
                    detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                list.add(detail);
            }
        });
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }
}

