/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfHrPersonMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.manager.QfHrPersonMManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfHrPersonMManagerImpl
extends BaseManagerImpl<QfHrPersonMDao, QfHrPersonM>
implements QfHrPersonMManager {
    @Autowired
    private QfHrPersonDManager personDManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        QfHrPersonM QfHrPersonM2 = (QfHrPersonM)((Object)((QfHrPersonMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)QfHrPersonM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.personDManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("HR");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        ArrayList detailList = Lists.newArrayList();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            for (HeaderNode node : nodes) {
                QfHrPersonD qfHrPersonD = new QfHrPersonD();
                if (0 == node.getRow() || node.getColumn() <= 1 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                qfHrPersonD.setMainId(mainId);
                qfHrPersonD.setFillData(new BigDecimal(node.getHeaderName()));
                qfHrPersonD.setFillDate(QfHrPersonM2.getFillDate());
                qfHrPersonD.setEnterpriseCode((String)headerMap.get(column));
                qfHrPersonD.setSubjectCode((String)subjectCodeMap.get(node.getRow()));
                if (!subjectMap.containsKey(qfHrPersonD.getSubjectCode())) {
                    noexitSubjectCodes.add(qfHrPersonD.getSubjectCode());
                } else {
                    QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(qfHrPersonD.getSubjectCode());
                    qfHrPersonD.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                    qfHrPersonD.setSubjectUnit(subjectInternationalInfo.getUnit());
                    qfHrPersonD.setSubjectName(subjectInternationalInfo.getName());
                    if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                        qfHrPersonD.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                    }
                }
                if (enterpriseInfoMap.containsKey(qfHrPersonD.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(qfHrPersonD.getEnterpriseCode());
                    qfHrPersonD.setEnterpriseName(qfEnterpriseInfo.getName());
                    qfHrPersonD.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                detailList.add(qfHrPersonD);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noexitSubjectCodes)) {
            throw new BaseException(((Object)noexitSubjectCodes).toString() + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        boolean bl = this.personDManager.saveBatch(detailList);
        return bl;
    }

    @Override
    public boolean updateStatus(QfHrPersonM t) {
        QfHrPersonM QfHrPersonM2 = (QfHrPersonM)((Object)((QfHrPersonMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfHrPersonM2) {
            return false;
        }
        QfHrPersonM2.setStatus(QfHrPersonM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfHrPersonMDao)this.baseMapper).updateById((Object)QfHrPersonM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfHrPersonM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfHrPersonMS = ((QfHrPersonMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfHrPersonMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfHrPersonMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfHrPersonM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfHrPersonMS = ((QfHrPersonMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfHrPersonMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfHrPersonMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

