/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceReportingSummaryMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryDManager;
import com.artfess.cqlt.manager.QfFinanceReportingSummaryMManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceReportingSummaryD;
import com.artfess.cqlt.model.QfFinanceReportingSummaryM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinanceReportingSummaryMManagerImpl
extends BaseManagerImpl<QfFinanceReportingSummaryMDao, QfFinanceReportingSummaryM>
implements QfFinanceReportingSummaryMManager {
    @Autowired
    private QfFinanceReportingSummaryDManager financeReportingSummaryDManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfFinanceReportingSummaryM t) {
        QfFinanceReportingSummaryM QfFinanceReportingSummaryM2 = (QfFinanceReportingSummaryM)((Object)((QfFinanceReportingSummaryMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfFinanceReportingSummaryM2) {
            return false;
        }
        QfFinanceReportingSummaryM2.setStatus(QfFinanceReportingSummaryM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfFinanceReportingSummaryMDao)this.baseMapper).updateById((Object)QfFinanceReportingSummaryM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfFinanceReportingSummaryD> list, String mainId) {
        QfFinanceReportingSummaryM financeReportingSummaryM = (QfFinanceReportingSummaryM)((Object)((QfFinanceReportingSummaryMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)financeReportingSummaryM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.financeReportingSummaryDManager.remove((Wrapper)queryWrapper);
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("RS");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(financeReportingSummaryM.getFillDate());
            if (!subjectMap.containsKey(detail.getSubjectCode())) {
                noexitSubjectCodes.add(detail.getSubjectCode());
            } else {
                QfSubjectInternationalInfo subjectInternationalInfo = (QfSubjectInternationalInfo)((Object)((Object)subjectMap.get(detail.getSubjectCode())));
                detail.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                detail.setSubjectUnit(subjectInternationalInfo.getUnit());
                detail.setSubjectName(subjectInternationalInfo.getName());
                if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                    detail.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                }
            }
            if (!StringUtils.isEmpty((Object)detail.getEnterpriseCode())) {
                String[] split = detail.getEnterpriseCode().split("/");
                StringBuffer nameEnsb = new StringBuffer();
                StringBuffer namesb = new StringBuffer();
                for (String code : split) {
                    if (!enterpriseInfoMap.containsKey(code)) continue;
                    QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(code)));
                    namesb.append(",");
                    nameEnsb.append(",");
                    namesb.append(qfEnterpriseInfo.getName());
                    nameEnsb.append(qfEnterpriseInfo.getNameEn());
                }
                if (nameEnsb.length() > 1) {
                    detail.setEnterpriseNameEn(nameEnsb.substring(1));
                }
                if (namesb.length() > 1) {
                    detail.setEnterpriseName(namesb.substring(1));
                }
                detail.setType(1);
            } else {
                detail.setType(2);
            }
        });
        boolean b = this.financeReportingSummaryDManager.saveBatch(list);
        return b;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfFinanceReportingSummaryM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfFinanceReportingSummaryMS = ((QfFinanceReportingSummaryMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceReportingSummaryMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceReportingSummaryMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfFinanceReportingSummaryM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfFinanceReportingSummaryMS = ((QfFinanceReportingSummaryMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfFinanceReportingSummaryMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfFinanceReportingSummaryMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

