/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.AnalyseTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.trans.TransitionUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfFinancialStatisticalDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.FinancialVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinancialStatisticalManagerImpl
extends BaseManagerImpl<QfFinancialStatisticalDao, QfFinancialStatistical>
implements QfFinancialStatisticalManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinancialStatisticalManagerImpl.class);
    private static final String SALES_REVENUE = "FE002";
    @Autowired
    private SysSubjectTargetManager sysSubjectTargetManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveData(List<FinancialVo> list, DataInfoVo dataInfoVo, Integer dataType) {
        dataInfoVo.setDataType(dataType);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        List<SysSubjectTarget> targetList = this.sysSubjectTargetManager.getTargetList("Finance");
        if (CollectionUtils.isEmpty(targetList)) {
            return false;
        }
        List<QfFinancialStatistical> lastYearData = this.lastYearData(dataInfoVo);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        ArrayList dataList = Lists.newArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)dataInfoVo.getYear());
        query.eq((Object)"quarter_", (Object)dataInfoVo.getQuarter());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)qfFinancialStatisticals)) {
            targetList.forEach(target -> this.saveFinancialStatistical((SysSubjectTarget)((Object)target), dataList, list, dataType, dataInfoVo, enterpriseInfoMap));
        } else {
            Map<String, List<QfFinancialStatistical>> statisticalMap = qfFinancialStatisticals.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
            targetList.forEach(target -> {
                List statisticalList = Lists.newArrayList();
                if (statisticalMap.containsKey(target.getId())) {
                    statisticalList = (List)statisticalMap.get(target.getId());
                }
                this.updateFinancialStatistical((SysSubjectTarget)((Object)target), dataList, statisticalList, list, dataType);
            });
        }
        this.processSalesRevenue(dataList, targetList, dataInfoVo, lastYearData);
        try {
            this.partitionSave(dataList);
            return true;
        }
        catch (Exception e) {
            log.error("\u8d22\u52a1\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
    }

    private void processSalesRevenue(List<QfFinancialStatistical> dataList, List<SysSubjectTarget> targetList, DataInfoVo dataInfoVo, List<QfFinancialStatistical> lastYearDate) {
        Map<String, SysSubjectTarget> subjectTargetMap = targetList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        String salesRevenueTargetId = null;
        if (subjectTargetMap.containsKey(SALES_REVENUE)) {
            salesRevenueTargetId = subjectTargetMap.get(SALES_REVENUE).getId();
        }
        ArrayList list = Lists.newArrayList();
        String finalSalesRevenueTargetId = salesRevenueTargetId;
        dataList.forEach(detail -> {
            if (finalSalesRevenueTargetId.equals(detail.getTargetId())) {
                detail.setAnalyseType(detail.getEnterpriseArea().toString());
                list.add(detail);
            }
            if (AnalyseTypeEnum.ZZL.getType().equals(detail.getAnalyseType())) {
                list.add(detail);
            }
        });
        Map<String, List<QfFinancialStatistical>> statisticalMap = list.stream().filter(b -> !StringUtils.isEmpty((Object)b.getAnalyseType())).collect(Collectors.groupingBy(QfFinancialStatistical::getAnalyseType));
        Map<String, List<SysSubjectTarget>> targetMap = targetList.stream().filter(b -> !StringUtils.isEmpty((Object)b.getAnalyseType())).collect(Collectors.groupingBy(SysSubjectTarget::getAnalyseType));
        if (!CollectionUtils.isEmpty(lastYearDate)) {
            List<QfFinancialStatistical> statisticals = statisticalMap.get(AnalyseTypeEnum.ZZL.getType());
            statisticals.forEach(thisYearData -> {
                if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation())) {
                    return;
                }
                lastYearDate.forEach(lastYearData -> {
                    if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation())) {
                        return;
                    }
                    if (!lastYearData.getTargetId().equals(thisYearData.getTargetId())) {
                        return;
                    }
                    if (!lastYearData.getEnterpriseCode().equals(thisYearData.getEnterpriseCode())) {
                        return;
                    }
                    Map lastYearCalculationMap = (Map)JSONObject.parseObject((String)lastYearData.getTargetCalculation(), Map.class);
                    Map thisYearCalculationMap = (Map)JSONObject.parseObject((String)thisYearData.getTargetCalculation(), Map.class);
                    Map thisYearDataMap = (Map)thisYearCalculationMap.get(dataInfoVo.getDataType());
                    Map lastYearDataMap = (Map)lastYearCalculationMap.get(dataInfoVo.getDataType());
                    if (CollectionUtils.isEmpty((Map)thisYearDataMap) || CollectionUtils.isEmpty((Map)lastYearCalculationMap)) {
                        return;
                    }
                    String targetCalculation = thisYearData.getTempCalculation();
                    List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
                    String thisYearCalculation = CommonUtil.replaceExpression((List)expressionKey, (String)targetCalculation, (Map)thisYearDataMap);
                    String lastYearCalculation = CommonUtil.replaceExpression((List)expressionKey, (String)targetCalculation, (Map)lastYearDataMap);
                    if (expressionKey.size() == thisYearDataMap.size() && expressionKey.size() == lastYearDataMap.size()) {
                        BigDecimal thisYearValue = CommonUtil.convertToCode((String)thisYearCalculation, (Map)thisYearDataMap, (int)2);
                        BigDecimal lastYearValue = CommonUtil.convertToCode((String)lastYearCalculation, (Map)lastYearDataMap, (int)2);
                        BigDecimal value = thisYearValue.subtract(lastYearValue).divide(lastYearValue, 2, 4).multiply(new BigDecimal(100));
                        if (dataInfoVo.getDataType() == 1) {
                            thisYearData.setActual(value);
                        } else if (dataInfoVo.getDataType() == 2) {
                            thisYearData.setBudget(value);
                        }
                    }
                });
            });
        }
        targetMap.forEach((analyseType, v) -> {
            List statisticals = (List)statisticalMap.get(analyseType);
            if (CollectionUtils.isEmpty((Collection)statisticals)) {
                return;
            }
            if (!AnalyseTypeEnum.ZZL.getType().equals(analyseType)) {
                BigDecimal actual = BigDecimal.ZERO;
                BigDecimal budget = BigDecimal.ZERO;
                for (QfFinancialStatistical qfFinancialStatistical : statisticals) {
                    budget = budget.add(null == qfFinancialStatistical.getBudget() ? budget : qfFinancialStatistical.getBudget());
                    actual = actual.add(null == qfFinancialStatistical.getActual() ? actual : qfFinancialStatistical.getActual());
                }
                BigDecimal finalActual = actual;
                BigDecimal finalBudget = budget;
                v.forEach(target -> {
                    QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
                    qfFinancialStatistical.setBudget(finalBudget);
                    qfFinancialStatistical.setActual(finalActual);
                    this.createInfo((SysSubjectTarget)((Object)((Object)target)), dataInfoVo, qfFinancialStatistical);
                    dataList.add(qfFinancialStatistical);
                });
            }
        });
    }

    private List<QfFinancialStatistical> lastYearData(DataInfoVo dataInfoVo) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)(dataInfoVo.getYear() - 1));
        query.eq((Object)"quarter_", (Object)dataInfoVo.getQuarter());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        query.eq((Object)"analyse_type_", (Object)AnalyseTypeEnum.ZZL.getType());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        return qfFinancialStatisticals;
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        if (StringUtils.isEmpty((Object)t.getTargetId())) {
            t.setTargetLevel("1");
        }
        List<QfFinancialStatistical> list = ((QfFinancialStatisticalDao)this.baseMapper).getGroupData(t);
        Map<String, List<QfFinancialStatistical>> statisticalMap = list.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
        ArrayList data = Lists.newArrayList();
        statisticalMap.forEach((k, v) -> {
            QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
            qfFinancialStatistical.setData((List<QfFinancialStatistical>)v);
            qfFinancialStatistical.setTargetId((String)k);
            if (!CollectionUtils.isEmpty((Collection)v)) {
                QfFinancialStatistical financialStatistical = (QfFinancialStatistical)((Object)((Object)v.get(0)));
                qfFinancialStatistical.setTargetUnit(financialStatistical.getTargetUnit());
                qfFinancialStatistical.setTargetName(financialStatistical.getTargetName());
                qfFinancialStatistical.setTargetNameEn(financialStatistical.getTargetNameEn());
                qfFinancialStatistical.setType(financialStatistical.getType());
                qfFinancialStatistical.setAnalyseType(financialStatistical.getAnalyseType());
                qfFinancialStatistical.setLargerType(financialStatistical.getLargerType());
                qfFinancialStatistical.setStaLat(financialStatistical.getStaLat());
                qfFinancialStatistical.setSn(financialStatistical.getSn());
            }
            data.add(qfFinancialStatistical);
        });
        ArrayList resultList = Lists.newArrayList();
        data.forEach(fa -> {
            if (StringUtils.isEmpty((Object)fa.getType())) {
                return;
            }
            List<String> typeList = Arrays.asList(fa.getType().split(","));
            typeList.forEach(type -> {
                FaTargetRespVo resultFa = new FaTargetRespVo();
                resultFa.setTargerId(fa.getTargetId());
                resultFa.setTargetName(fa.getTargetName());
                resultFa.setTargetNameEn(fa.getTargetNameEn());
                resultFa.setTargetUnit(fa.getTargetUnit());
                resultFa.setStaLat(fa.getStaLat());
                resultFa.setType((String)type);
                resultFa.setSn(fa.getSn());
                switch (type) {
                    case "1": {
                        List reportRespVos = TransitionUtil.copyList(fa.getData(), FaReportRespVo.class, null);
                        resultFa.setResultData(reportRespVos);
                        resultList.add(resultFa);
                        break;
                    }
                    case "6": {
                        if (!CollectionUtils.isEmpty(fa.getData())) {
                            resultFa.setShowValue(fa.getData().get(fa.getData().size() - 1).getActual());
                        }
                        resultList.add(resultFa);
                        break;
                    }
                }
            });
        });
        return resultList;
    }

    @Override
    public List<FaReportRespVo> enterpriseData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        int year = LocalDate.now().getYear();
        t.setYear(year);
        return ((QfFinancialStatisticalDao)this.baseMapper).enterpriseData(t);
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        List<QfFinancialStatistical> monthData;
        List<QfFinancialStatistical> quarterData;
        List<QfFinancialStatistical> yearData;
        ArrayList resultList = Lists.newArrayList();
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        if (null == t.getStartMonth() || null == t.getEndMonth()) {
            t.setYear(t.getQuarterYear());
            t.setEndMonth(12);
            t.setStartMonth(1);
        }
        if (!CollectionUtils.isEmpty(yearData = ((QfFinancialStatisticalDao)this.baseMapper).yearData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargerId(yearData.get(0).getTargetId());
            resultFa.setTargetName(yearData.get(0).getTargetName());
            resultFa.setTargetNameEn(yearData.get(0).getTargetNameEn());
            resultFa.setTargetUnit(yearData.get(0).getTargetUnit());
            resultFa.setStaLat(yearData.get(0).getStaLat());
            resultFa.setType("2");
            List reportRespVos = TransitionUtil.copyList(yearData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(quarterData = ((QfFinancialStatisticalDao)this.baseMapper).quarterData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargerId(quarterData.get(0).getTargetId());
            resultFa.setTargetName(quarterData.get(0).getTargetName());
            resultFa.setTargetNameEn(quarterData.get(0).getTargetNameEn());
            resultFa.setTargetUnit(quarterData.get(0).getTargetUnit());
            resultFa.setStaLat(quarterData.get(0).getStaLat());
            resultFa.setType("3");
            List reportRespVos = TransitionUtil.copyList(quarterData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        if (!CollectionUtils.isEmpty(monthData = ((QfFinancialStatisticalDao)this.baseMapper).monthData(t))) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargerId(monthData.get(0).getTargetId());
            resultFa.setTargetName(monthData.get(0).getTargetName());
            resultFa.setTargetNameEn(monthData.get(0).getTargetNameEn());
            resultFa.setTargetUnit(monthData.get(0).getTargetUnit());
            resultFa.setStaLat(monthData.get(0).getStaLat());
            resultFa.setType("4");
            List reportRespVos = TransitionUtil.copyList(monthData, FaReportRespVo.class, null);
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        SysSubjectTarget target = (SysSubjectTarget)this.sysSubjectTargetManager.get((Serializable)((Object)t.getTargetId()));
        t.setParentTargetId(target.getSubjectId());
        t.setTargetId(null);
        List<QfFinancialStatistical> fromUnderTargtYearData = ((QfFinancialStatisticalDao)this.baseMapper).yearData(t);
        if (!CollectionUtils.isEmpty(fromUnderTargtYearData)) {
            Map<String, List<QfFinancialStatistical>> statisticalMap = fromUnderTargtYearData.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
            statisticalMap.forEach((k, v) -> {
                FaTargetRespVo resultFa = new FaTargetRespVo();
                resultFa.setType("1");
                resultFa.setTargerId(((QfFinancialStatistical)((Object)((Object)v.get(0)))).getTargetId());
                resultFa.setTargetName(((QfFinancialStatistical)((Object)((Object)v.get(0)))).getTargetName());
                resultFa.setTargetNameEn(((QfFinancialStatistical)((Object)((Object)v.get(0)))).getTargetNameEn());
                resultFa.setTargetUnit(((QfFinancialStatistical)((Object)((Object)v.get(0)))).getTargetUnit());
                resultFa.setStaLat(((QfFinancialStatistical)((Object)((Object)v.get(0)))).getStaLat());
                if (!CollectionUtils.isEmpty((Collection)v)) {
                    List reportRespVos = TransitionUtil.copyList((List)v, FaReportRespVo.class, null);
                    resultFa.setResultData(reportRespVos);
                }
                resultList.add(resultFa);
            });
        }
        return resultList;
    }

    private void partitionSave(List<QfFinancialStatistical> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void saveFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<FinancialVo> list, Integer dataType, DataInfoVo dataInfoVo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        Map<String, List<FinancialVo>> enterpriseMap = list.stream().collect(Collectors.groupingBy(FinancialVo::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseMap.forEach((enterpriseCode, financialVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
            qfFinancialStatistical.setTempCalculation(targetCalculation);
            this.createInfo(target, dataInfoVo, qfFinancialStatistical);
            this.calculateData(dataType, targetCalculation, expressionKey, (List<FinancialVo>)financialVoList, qfFinancialStatistical);
            if (!StringUtil.isNotEmpty((String)target.getAnalyseType()) || AnalyseTypeEnum.ZZL.getType().equals(target.getAnalyseType())) {
                qfFinancialStatistical.setEnterpriseArea(Integer.parseInt(qfEnterpriseInfo.getContinent()));
                qfFinancialStatistical.setEnterpriseType(qfEnterpriseInfo.getBusinessType());
                qfFinancialStatistical.setEnterpriseCode((String)enterpriseCode);
                dataList.add(qfFinancialStatistical);
            }
        });
    }

    private void calculateData(Integer dataType, String targetCalculation, List<String> expressionKey, List<FinancialVo> financialVoList, QfFinancialStatistical qfFinancialStatistical) {
        String targetCalculationJson = qfFinancialStatistical.getTargetCalculation();
        Map map = (Map)JSONObject.parseObject((String)targetCalculationJson, Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        }
        HashMap targetCalculationMap = Maps.newHashMap();
        Map finalMap = map;
        expressionKey.forEach(key -> {
            if (StringUtils.isEmpty((Object)key)) {
                return;
            }
            financialVoList.forEach(financialVo -> {
                if (StringUtils.isEmpty((Object)financialVo.getSubjectCode()) || !financialVo.getSubjectCode().equals(key)) {
                    return;
                }
                if (dataType == 1 && null == financialVo.getActual()) {
                    financialVo.setActual(BigDecimal.ZERO);
                }
                if (dataType == 2 && null == financialVo.getBudget()) {
                    financialVo.setBudget(BigDecimal.ZERO);
                }
                if (CollectionUtils.isEmpty((Map)finalMap)) {
                    targetCalculationMap.put(key, dataType == 1 ? financialVo.getActual() : financialVo.getBudget());
                    finalMap.put(dataType, targetCalculationMap);
                } else {
                    Map stringBigDecimalMap = (Map)finalMap.get(dataType);
                    if (!CollectionUtils.isEmpty((Map)stringBigDecimalMap)) {
                        for (Map.Entry entry : stringBigDecimalMap.entrySet()) {
                            if (!key.equals(entry.getKey())) continue;
                            targetCalculationMap.put(entry.getKey(), dataType == 1 ? financialVo.getActual() : financialVo.getBudget());
                        }
                        if (!targetCalculationMap.containsKey(key)) {
                            targetCalculationMap.put(key, dataType == 1 ? financialVo.getActual() : financialVo.getBudget());
                        }
                        finalMap.put(dataType, targetCalculationMap);
                    } else {
                        targetCalculationMap.put(key, dataType == 1 ? financialVo.getActual() : financialVo.getBudget());
                        finalMap.put(dataType, targetCalculationMap);
                    }
                }
            });
        });
        targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)targetCalculation, (Map)targetCalculationMap);
        log.info("expressionKey:{},targetCalculation:{},targetCalculationMap:{}", new Object[]{expressionKey, targetCalculation, targetCalculationMap});
        qfFinancialStatistical.setTargetCalculation(JSON.toJSONString((Object)finalMap));
        if (expressionKey.size() == targetCalculationMap.size() && !StringUtil.isNotEmpty((String)qfFinancialStatistical.getAnalyseType())) {
            BigDecimal bigDecimal = CommonUtil.convertToCode((String)targetCalculation, (Map)targetCalculationMap, (int)2);
            if (StringUtil.isNotEmpty((String)qfFinancialStatistical.getTargetCalculation()) && qfFinancialStatistical.getTargetUnit().equals("%")) {
                bigDecimal = bigDecimal.multiply(new BigDecimal(100));
            }
            if (dataType == 1) {
                qfFinancialStatistical.setActual(bigDecimal);
            } else if (dataType == 2) {
                qfFinancialStatistical.setBudget(bigDecimal);
            }
        }
    }

    private void createInfo(SysSubjectTarget target, DataInfoVo dataInfoVo, QfFinancialStatistical qfFinancialStatistical) {
        qfFinancialStatistical.setTargetId(target.getId());
        qfFinancialStatistical.setTargetLevel(target.getTargetLevel());
        qfFinancialStatistical.setTargetName(target.getName());
        qfFinancialStatistical.setTargetNameEn(target.getTargetNameEn());
        qfFinancialStatistical.setTargetUnit(target.getUnit());
        qfFinancialStatistical.setType(target.getType());
        qfFinancialStatistical.setStaLat(target.getStaLat());
        qfFinancialStatistical.setAnalyseType(target.getAnalyseType());
        qfFinancialStatistical.setLargerType(target.getLargerType());
        qfFinancialStatistical.setParentTargetId(target.getParentId());
        qfFinancialStatistical.setYear(dataInfoVo.getYear());
        qfFinancialStatistical.setQuarter(dataInfoVo.getQuarter());
        qfFinancialStatistical.setMonth(dataInfoVo.getMonth());
    }

    private void updateFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<QfFinancialStatistical> statisticalList, List<FinancialVo> list, Integer dataType) {
        if (CollectionUtils.isEmpty(statisticalList)) {
            return;
        }
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        statisticalList.forEach(qfFinancialStatistical -> {
            this.calculateData(dataType, targetCalculation, expressionKey, list, (QfFinancialStatistical)((Object)qfFinancialStatistical));
            qfFinancialStatistical.setTempCalculation(targetCalculation);
            dataList.add((QfFinancialStatistical)((Object)qfFinancialStatistical));
        });
    }
}

